package cn.smarthse.rho.core.framework;

import java.time.Duration;

/**
 * 常量类
 *
 * @author liaoly
 * @date 2022/2/11 22:56
 */
public class Constant {

    /**
     * 定时任务oidorcid
     */
    public static final Long TASK_OIDORCID = -1L;
    /**
     * 定时任务操作人id
     */
    public static final Long TASK_OPERATOR_ID = -1L;
    /**
     * 定时任务操作人名称
     */
    public static final String TASK_OPERATOR_NAME = "系统";

    /**
     * 精度蓝牙定位设备坐标异常数据日统计表日志model
     */
    public static Integer X_PDDS_STA_DAY_LOG_MODEL = 31;

    /**
     * 链路追踪标记
     */
    public static String trackId = "trackId";

    /**
     * 有效/无效
     */
    public static final Integer ACTIVE_YES = 1;
    public static final Integer ACTIVE_NO = 0;

    /**
     * 密码相关
     */
    public static class Password {
        /**
         * 默认密码 Zyj@2022
         */
        public static final String DEFAULT_PWD = "Zyj@2022";
        /**
         * 密码最长有效期90天（超过提示修改密码）
         */
        public static final int MAX_PASSWORD_EXPIRE_DAY = 90;
        /**
         * 密码的盐值长度为 8
         */
        public static final int SALT_SIZE = 8;
        /**
         * 密码hash次数
         */
        public static final int HASH_ITERATIONS = 1024;
    }

    /**
     * 图形验证码
     */
    public static class Vcode {
        /**
         * 图形验证码过期时间 此处为五分钟
         */
        public static final int CODE_EXPIRE_TIME = 5;
        /**
         * 验证码- 默认长度
         */
        public static final int DEFAULT_LEN = 4;
        /**
         * 验证码- 默认宽度
         */
        public static final int DEFAULT_WIDTH = 130;
        /**
         * 验证码- 默认高度
         */
        public static final int DEFAULT_HEIGHT = 48;
    }

    /**
     * 有效期（分钟）
     */
    public static final Duration TEMP_EXPIRATION = Duration.ofMinutes(5);
    public static final Long TEMP_TOKEN_TIMEOUT = 1000 * 60 * 5L;
    /**
     * 全局 redis key
     */
    public static final String GLOBAL_REDIS_KEY = "global:";

    public static final String SPLICING_TEMP_LOGIN_INFORMATION_KEY = GLOBAL_REDIS_KEY + "temp:login:information:";
    /**
     * zzd redis key
     */
    public static final String SPLICING_ZZD_ACCESS_TOKEN_KEY = GLOBAL_REDIS_KEY + "supervise:zzd:accessToken:";
    /**
     * 验证码 redis key
     */
    public static final String SPLICING_CAPTCHA_CODE_KEY = GLOBAL_REDIS_KEY + "captcha_codes:";
    /**
     * 登录账户密码错误次数 redis key
     */
    public static final String SPLICING_PWD_ERR_CNT_KEY = GLOBAL_REDIS_KEY + "pwd_err_cnt:";
    /**
     * 绑定换绑联系人 redis key
     */
    public static final String USER_BIND_KEY = GLOBAL_REDIS_KEY + "user:bind:";

    public static final String VCODE_TEMPLATE = "【浙江省疾控局】您的验证码是: %s，有效期5分钟，请尽快进行后续操作。";
    public static final String SUPERVISE_VCODE_TEMPLATE = "【浙江省疾控局】您正在登录”放射卫生在线·监管端“，登录验证码为 %s （切勿告知他人），有效期5分钟，请尽快进行后续操作。";
    public static final String COMPANY_VCODE_TEMPLATE = "【浙江省疾控局】您正在登录”放射卫生在线·放射诊疗机构端“，登录验证码为 %s （切勿告知他人），有效期5分钟，请尽快进行后续操作。";
    public static final String BIND_VCODE_TEMPLATE = "【浙江省疾控局】您正在进行绑定手机号的操作，验证码为 %s （切勿告知他人），有效期5分钟，请尽快进行后续操作。";
    public static final String RBIND_VCODE_TEMPLATE = "【浙江省疾控局】您正在进行手机号换绑，换绑验证码为 %s （切勿告知他人），有效期5分钟，请尽快进行后续操作。";
    public static final String RESET_VCODE_TEMPLATE = "【浙江省疾控局】您正在重置“放射卫生在线·放射诊疗机构端”密码，验证码为 %s （切勿告知他人），有效期5分钟，请尽快进行后续操作。";
    public static final String UPDATE_BIND_SUCCESS_TEMPLATE = "【浙江省疾控局】您申请的手机号换绑已通过，请及时登录“放射卫生在线”进行验证。";
    public static final String UPDATE_BIND_FAIL_TEMPLATE = "【浙江省疾控局】您申请的手机号换绑因“提交的《手机号换绑授权委托书》不符合要求”未通过，请重新提交。";
    public static final String UNBIND_MESSAGE = "【浙江省疾控局】您的手机号已与“放射卫生在线”账号解绑成功，请尽快至“放射卫生在线”绑定新的手机号。";

}
