/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.framework.utils.login;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.core.framework.Constant;
import cn.smarthse.core.framework.utils.ServletUtils;
import cn.smarthse.core.framework.utils.StringUtils;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.Date;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.MDC;

public class JwtUtil {
    public static Long getUserId() {
        try {
            DecodedJWT jwt = JWT.decode((String)JwtUtil.getToken());
            return jwt.getClaim("userId").asLong();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Long getUserId(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim("userId").asLong();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getUsername() {
        try {
            DecodedJWT jwt = JWT.decode((String)JwtUtil.getToken());
            return jwt.getClaim("username").asString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getUsername(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim("username").asString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getFullName() {
        try {
            DecodedJWT jwt = JWT.decode((String)JwtUtil.getToken());
            return jwt.getClaim("fullName").asString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getFullName(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim("fullName").asString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Long getOid() {
        try {
            DecodedJWT jwt = JWT.decode((String)JwtUtil.getToken());
            return jwt.getClaim("oid").asLong();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Long getOid(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim("oid").asLong();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Long getCid() {
        try {
            DecodedJWT jwt = JWT.decode((String)JwtUtil.getToken());
            return jwt.getClaim("cid").asLong();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Long getCid(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim("cid").asLong();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Long getAreaId() {
        try {
            DecodedJWT jwt = JWT.decode((String)JwtUtil.getToken());
            return jwt.getClaim("areaId").asLong();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Long getAreaId(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim("areaId").asLong();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Integer getIsTest() {
        try {
            DecodedJWT jwt = JWT.decode((String)JwtUtil.getToken());
            return jwt.getClaim("isTest").asInt();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Integer getIsTest(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim("isTest").asInt();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Integer getLoginType() {
        try {
            DecodedJWT jwt = JWT.decode((String)JwtUtil.getToken());
            return jwt.getClaim("loginType").asInt();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Integer getLoginType(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim("loginType").asInt();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getToken() {
        String token;
        HttpServletRequest request = ServletUtils.getRequest();
        if (request == null) {
            token = MDC.get((String)Constant.TOKEN_HEADER_NAME);
        } else {
            token = request.getHeader(Constant.TOKEN_HEADER_NAME);
            if (StrUtil.isBlank((CharSequence)token)) {
                token = request.getParameter(Constant.REFRESH_TOKEN_HEADER_NAME);
            }
        }
        return token;
    }

    public static String getToken(HttpServletRequest request) {
        String token = request.getHeader(Constant.TOKEN_HEADER_NAME);
        if (StrUtil.isBlank((CharSequence)token)) {
            return request.getParameter(Constant.REFRESH_TOKEN_HEADER_NAME);
        }
        return token;
    }

    public static String createToken(Long userId, String username, String fullName, Long oid, Long cid, Long areaId, Integer isTest, Integer loginType, String secret, Long time) {
        Date date = new Date(System.currentTimeMillis() + time);
        Algorithm algorithm = Algorithm.HMAC256((String)secret);
        return JWT.create().withClaim("userId", userId).withClaim("username", username).withClaim("fullName", fullName).withClaim("oid", oid).withClaim("cid", cid).withClaim("areaId", areaId).withClaim("isTest", isTest).withClaim("loginType", loginType).withExpiresAt(date).sign(algorithm);
    }

    public static String refreshToken(String token, String secret) {
        return JwtUtil.createToken(JwtUtil.getUserId(token), JwtUtil.getUsername(token), JwtUtil.getFullName(token), JwtUtil.getOid(token), JwtUtil.getCid(token), JwtUtil.getAreaId(token), JwtUtil.getIsTest(token), JwtUtil.getLoginType(token), secret, Constant.TOKEN_EXPIRE_TIME);
    }

    public static boolean verify(String token, String secret) {
        if (StringUtils.isBlank((CharSequence)secret)) {
            return false;
        }
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)secret);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).withClaim("username", JwtUtil.getUsername(token)).withClaim("userId", JwtUtil.getUserId(token)).build();
            verifier.verify(token);
            return true;
        }
        catch (JWTVerificationException exception) {
            return false;
        }
    }

    public static Boolean isTokenExpired(String token) {
        Date expiration = JwtUtil.getExpiration(token);
        return expiration == null || expiration.before(new Date());
    }

    public static Date getExpiration(String token) {
        try {
            return ((Claim)JWT.decode((String)token).getClaims().get("exp")).asDate();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Long getExpirationLong(String token) {
        try {
            return ((Claim)JWT.decode((String)token).getClaims().get("exp")).asLong();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static Long getExpirationMillis(String token) {
        try {
            return ((Claim)JWT.decode((String)token).getClaims().get("exp")).asLong() * 1000L;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static Boolean isOnlineSpecialSuperAndTestUser() {
        String loginUserName = JwtUtil.getUsername();
        return "superuser".equalsIgnoreCase(loginUserName) || Objects.equals(JwtUtil.getIsTest(), 1);
    }
}

