/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.framework.utils;

public class PolygonAreaUtil {
    private static double crossProduct(double x1, double y1, double x2, double y2, double x3, double y3) {
        return (x2 - x1) * (y3 - y1) - (y2 - y1) * (x3 - x1);
    }

    public static boolean isPointInsidePolygon(double x, double y, double[] xPoints, double[] yPoints) {
        int numVertices = xPoints.length;
        if (numVertices != yPoints.length || numVertices < 3) {
            throw new IllegalArgumentException("The number of points must be at least 3 and equal in both arrays.");
        }
        boolean inside = false;
        int i = 0;
        int j = numVertices - 1;
        while (i < numVertices) {
            if (yPoints[i] == y && (xPoints[j] > x || xPoints[j] == x && xPoints[i] <= x) || yPoints[j] == y && (xPoints[i] > x || xPoints[i] == x && xPoints[j] <= x) || y > Math.min(yPoints[i], yPoints[j]) && y < Math.max(yPoints[i], yPoints[j]) && x < Math.max(xPoints[i], xPoints[j]) && PolygonAreaUtil.crossProduct(xPoints[i], yPoints[i], xPoints[j], yPoints[j], x, y) == 0.0) {
                return true;
            }
            if (yPoints[i] > y != yPoints[j] > y && x < (xPoints[j] - xPoints[i]) * (y - yPoints[i]) / (yPoints[j] - yPoints[i]) + xPoints[i]) {
                inside = !inside;
            }
            j = i++;
        }
        return inside;
    }

    public static void main(String[] args) {
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 1.0;
        double y2 = 0.0;
        double x3 = 1.0;
        double y3 = 1.0;
        double x4 = 0.0;
        double y4 = 1.0;
        double[] xPoints = new double[]{x1, x2, x3, x4};
        double[] yPoints = new double[]{y1, y2, y3, y4};
        double testX = 2.5;
        double testY = 0.5;
        boolean inside = PolygonAreaUtil.isPointInsidePolygon(testX, testY, xPoints, yPoints);
        System.out.println("Is point (" + testX + ", " + testY + ") inside the polygon? " + inside);
    }
}

