/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.framework.utils;

import java.util.List;

public class FileContentTypeUtils {
    public static String contentType(String FilenameExtension) {
        if (FilenameExtension.toUpperCase().contains(".BMP")) {
            return "image/bmp";
        }
        if (FilenameExtension.toUpperCase().contains(".GIF")) {
            return "image/gif";
        }
        if (FilenameExtension.toUpperCase().contains(".JPEG") || FilenameExtension.toUpperCase().contains(".JPG") || FilenameExtension.toUpperCase().contains(".PNG")) {
            return "image/jpeg";
        }
        if (FilenameExtension.toUpperCase().contains(".HTML")) {
            return "text/html";
        }
        if (FilenameExtension.toUpperCase().contains(".TXT")) {
            return "text/plain";
        }
        if (FilenameExtension.toUpperCase().contains(".VSD")) {
            return "application/vnd.visio";
        }
        if (FilenameExtension.toUpperCase().contains(".PPTX") || FilenameExtension.toUpperCase().contains(".PPT")) {
            return "application/vnd.ms-powerpoint";
        }
        if (FilenameExtension.toUpperCase().contains(".DOCX") || FilenameExtension.toUpperCase().contains(".DOC")) {
            return "application/msword";
        }
        if (FilenameExtension.toUpperCase().contains(".XML")) {
            return "text/xml";
        }
        if (FilenameExtension.toUpperCase().contains(".PDF")) {
            return "application/pdf";
        }
        return null;
    }

    public static String imgTypeValid(String dataPrix) {
        if ("data:image/jpeg;".equalsIgnoreCase(dataPrix)) {
            return ".jpeg";
        }
        if ("data:image/jpg;".equalsIgnoreCase(dataPrix)) {
            return ".jpg";
        }
        if ("data:image/gif;".equalsIgnoreCase(dataPrix)) {
            return ".gif";
        }
        if ("data:image/png;".equalsIgnoreCase(dataPrix)) {
            return ".png";
        }
        if ("data:image/apng;".equalsIgnoreCase(dataPrix)) {
            return ".apng";
        }
        if ("data:image/svg;".equalsIgnoreCase(dataPrix)) {
            return ".svg";
        }
        if ("data:image/bmp;".equalsIgnoreCase(dataPrix)) {
            return ".bmp";
        }
        return null;
    }

    public static String fileTypeValid(String dataPrix) {
        if ("data:text/plain;".equalsIgnoreCase(dataPrix)) {
            return ".txt";
        }
        return null;
    }

    public static boolean checkSupportFileTypes(List<String> supportFileTypes, String fileName) {
        return supportFileTypes != null && supportFileTypes.size() > 0 && fileName != null && supportFileTypes.contains(fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase());
    }
}

