/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.framework.utils;

import cn.smarthse.core.framework.model.LayuiGridData;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Supplier;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(EasyExcelUtil.class);

    public static void exportDynamicExcel(List<String> includeColumnFiledNames, String fileName, Class<?> clazz, HttpServletResponse response, Supplier<LayuiGridData<?>> supplier) {
        try {
            ServletOutputStream os = response.getOutputStream();
            response.setContentType("application/octet-stream");
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            String encodeFileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8.name()).replaceAll("\\+", "%20");
            response.setHeader("Content-Disposition", "attachment;filename=" + encodeFileName + ".xlsx");
            ExcelWriterBuilder excelBuilder = EasyExcel.write((OutputStream)response.getOutputStream(), clazz);
            EasyExcelUtil.includeColumnFiledName(includeColumnFiledNames, excelBuilder);
            ExcelWriter excelWriter = excelBuilder.build();
            EasyExcelUtil.export(excelWriter, supplier);
        }
        catch (IOException e) {
            log.error("\u5206\u9875\u5bfc\u51faExcel\u5f02\u5e38", (Throwable)e);
        }
    }

    public static void exportDynamicExcel(List<String> includeColumnFiledNames, String fileName, List<?> list, Class<?> clazz, HttpServletResponse response) {
        try {
            ServletOutputStream os = response.getOutputStream();
            response.setContentType("application/octet-stream");
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            String encodeFileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8.name()).replaceAll("\\+", "%20");
            response.setHeader("Content-Disposition", "attachment;filename=" + encodeFileName + ".xlsx");
            ExcelWriterBuilder excelBuilder = EasyExcel.write((OutputStream)os, clazz);
            excelBuilder = EasyExcelUtil.includeColumnFiledName(includeColumnFiledNames, excelBuilder);
            ((ExcelWriterBuilder)excelBuilder.useDefaultStyle(Boolean.valueOf(false))).sheet("Sheet1").doWrite(list);
            os.close();
        }
        catch (IOException e) {
            log.error("\u5bfc\u51faExcel\u5f02\u5e38", (Throwable)e);
        }
    }

    private static ExcelWriterBuilder includeColumnFiledName(List<String> includeColumnFieldNames, ExcelWriterBuilder excelBuilder) {
        excelBuilder = (ExcelWriterBuilder)excelBuilder.registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy());
        if (!includeColumnFieldNames.isEmpty()) {
            excelBuilder = (ExcelWriterBuilder)excelBuilder.includeColumnFieldNames(includeColumnFieldNames);
        }
        excelBuilder = (ExcelWriterBuilder)excelBuilder.registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy());
        return excelBuilder;
    }

    private static void export(ExcelWriter excelWriter, Supplier<LayuiGridData<?>> supplier) {
        LayuiGridData<?> res;
        long pages;
        long page = 1L;
        do {
            res = supplier.get();
            excelWriter.write(res.getData(), EasyExcel.writerSheet((String)"Sheet1").build());
        } while (++page < (pages = res.getPages()));
        excelWriter.finish();
    }
}

