/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.framework.shiro;

import cn.smarthse.common.redis.utils.RedisUtils;
import cn.smarthse.core.framework.RedisKey;
import cn.smarthse.core.framework.bootstrap.properties.SysProperties;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.ExcessiveAttemptsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;

public class ShiroAuthorizingCredentialsMatcher
extends HashedCredentialsMatcher {
    private final SysProperties sysProperties;

    public boolean doCredentialsMatch(AuthenticationToken token, AuthenticationInfo info) {
        String keyName = RedisKey.passwordRetry((String)token.getPrincipal());
        AtomicInteger retryCacheCount = (AtomicInteger)RedisUtils.getCacheObject((String)keyName);
        if (retryCacheCount != null && retryCacheCount.get() >= this.retryCount()) {
            throw new LockedAccountException();
        }
        boolean matches = super.doCredentialsMatch(token, info);
        if (matches) {
            RedisUtils.deleteObject((String)keyName);
        } else {
            AtomicInteger updateRetryCacheCount = retryCacheCount == null ? new AtomicInteger(0) : retryCacheCount;
            int currentCount = updateRetryCacheCount.incrementAndGet();
            if (currentCount > this.retryCount()) {
                throw new LockedAccountException(String.valueOf(currentCount));
            }
            RedisUtils.setCacheObject((String)keyName, (Object)updateRetryCacheCount, (Duration)Duration.ofMinutes(this.retryLockTime()));
            if (currentCount == 3) {
                throw new ExcessiveAttemptsException();
            }
        }
        return matches;
    }

    public int retryCount() {
        return this.sysProperties.getLogin().getRetryCount();
    }

    public int retryLockTime() {
        return this.sysProperties.getLogin().getRetryLockTime();
    }

    public ShiroAuthorizingCredentialsMatcher(SysProperties sysProperties) {
        this.sysProperties = sysProperties;
    }
}

