/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.framework.model;

import cn.smarthse.core.framework.model.ResponseStateEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;

@ApiModel
public class ResponseData<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value="\u72b6\u6001\u7801", example="0-\u64cd\u4f5c\u6210\u529f, 1-\u64cd\u4f5c\u5931\u8d25,2-\u8b66\u544a,400\u53c2\u6570\u4e0d\u5339\u914d,401-\u767b\u5f55\u5931\u6548,403\u65e0\u6743\u9650,500\u670d\u52a1\u5668\u51fa\u9519", required=true, position=-2)
    private Integer state = ResponseStateEnum.success.getValue();
    @ApiModelProperty(value="\u8fd4\u56de\u6d88\u606f\u63cf\u8ff0", example="\u64cd\u4f5c\u6210\u529f\uff01", required=true, position=-1)
    private String message = ResponseStateEnum.success.getName();
    @ApiModelProperty(value="\u6cdb\u578b\u6570\u636e\u5305")
    private T result;

    public ResponseData(Integer state, String message, T result) {
        this.state = state;
        this.message = message;
        this.result = result;
    }

    public ResponseData(Integer state, String message) {
        this.state = state;
        this.message = message;
    }

    public ResponseData(Integer state, T result) {
        this.state = state;
        this.message = ResponseStateEnum.getName(state);
        this.result = result;
    }

    public ResponseData(String message, T result) {
        this.message = message;
        this.result = result;
    }

    public ResponseData(T result) {
        this.message = ResponseStateEnum.success.getName();
        this.result = result;
    }

    public ResponseData(String message) {
        this.message = message;
    }

    public ResponseData(Integer state) {
        this(state, ResponseStateEnum.getName(state));
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public static ResponseData<String> success() {
        return new ResponseData<String>();
    }

    public static <T> ResponseData<T> success(T result) {
        return new ResponseData<T>(ResponseStateEnum.success.getValue(), result);
    }

    public static <T> ResponseData<T> success(String message, T result) {
        return new ResponseData<T>(ResponseStateEnum.success.getValue(), message, result);
    }

    public static ResponseData<String> fail() {
        return new ResponseData<String>(ResponseStateEnum.fail.getValue());
    }

    public static <T> ResponseData<T> fail(T result) {
        return new ResponseData<T>(ResponseStateEnum.fail.getValue(), ResponseStateEnum.fail.getName(), result);
    }

    public static <T> ResponseData<T> fail(String message) {
        return new ResponseData<T>(ResponseStateEnum.fail.getValue(), message);
    }

    public static <T> ResponseData<T> fail(String message, T result) {
        return new ResponseData<T>(ResponseStateEnum.fail.getValue(), message, result);
    }

    public ResponseData() {
    }

    public Integer getState() {
        return this.state;
    }

    public String getMessage() {
        return this.message;
    }

    public T getResult() {
        return this.result;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResponseData)) {
            return false;
        }
        ResponseData other = (ResponseData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$state = this.getState();
        Integer other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)this$state).equals(other$state)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$result = this.getResult();
        T other$result = other.getResult();
        return !(this$result == null ? other$result != null : !this$result.equals(other$result));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResponseData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        return result;
    }

    public String toString() {
        return "ResponseData(state=" + this.getState() + ", message=" + this.getMessage() + ", result=" + this.getResult() + ")";
    }
}

