/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.framework.model;

import cn.smarthse.core.framework.model.LayuiGridParam;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

public class LayuiGridData<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value="\u603b\u9875\u6570")
    private long pages;
    @ApiModelProperty(value="\u9875\u7801")
    private long page;
    @ApiModelProperty(value="\u603b\u6570")
    private long total;
    @ApiModelProperty(value="\u6570\u636e\u5b9e\u4f53")
    private List<T> data;

    public LayuiGridData(Page<T> rows, LayuiGridParam param) {
        if (rows != null && param.getLimit() > 0) {
            this.pages = rows.getTotal() % (long)param.getLimit() == 0L ? rows.getTotal() / (long)param.getLimit() : (long)rows.getPages();
            this.page = param.getPage();
            this.total = rows.getTotal();
            this.data = rows;
        }
    }

    public LayuiGridData(PageInfo<T> rows) {
        if (rows != null && rows.getPageSize() > 0) {
            this.pages = rows.getTotal() % (long)rows.getPageSize() == 0L ? rows.getTotal() / (long)rows.getPageSize() : (long)rows.getPages();
            this.page = rows.getPageNum();
            this.total = rows.getTotal();
            this.data = rows.getList();
        }
    }

    public LayuiGridData(List<T> data) {
        if (data != null) {
            this.page = 1L;
            this.pages = 1L;
            this.total = data.size();
            this.data = data;
        }
    }

    public LayuiGridData(List<T> allList, Integer page, Integer size) {
        this.page = page.intValue();
        if (allList == null) {
            return;
        }
        this.pages = allList.size() / size;
        if (allList.size() % size != 0) {
            ++this.pages;
        }
        this.total = allList.size();
        LinkedList<T> l = new LinkedList<T>();
        for (int i = (page - 1) * size; i < page * size && i < allList.size(); ++i) {
            l.add(allList.get(i));
        }
        this.data = l;
    }

    public LayuiGridData(List<T> allList, Integer page, Integer size, Integer total) {
        this.page = page.intValue();
        if (allList == null) {
            return;
        }
        this.pages = allList.size() / size;
        if (allList.size() % size != 0) {
            ++this.pages;
        }
        this.total = total.intValue();
        LinkedList<T> l = new LinkedList<T>();
        for (int i = (page - 1) * size; i < page * size && i < allList.size(); ++i) {
            l.add(allList.get(i));
        }
        this.data = l;
    }

    public long getPages() {
        return this.pages;
    }

    public long getPage() {
        return this.page;
    }

    public long getTotal() {
        return this.total;
    }

    public List<T> getData() {
        return this.data;
    }

    public void setPages(long pages) {
        this.pages = pages;
    }

    public void setPage(long page) {
        this.page = page;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public void setData(List<T> data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LayuiGridData)) {
            return false;
        }
        LayuiGridData other = (LayuiGridData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPages() != other.getPages()) {
            return false;
        }
        if (this.getPage() != other.getPage()) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        List<T> this$data = this.getData();
        List<T> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LayuiGridData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $pages = this.getPages();
        result = result * 59 + (int)($pages >>> 32 ^ $pages);
        long $page = this.getPage();
        result = result * 59 + (int)($page >>> 32 ^ $page);
        long $total = this.getTotal();
        result = result * 59 + (int)($total >>> 32 ^ $total);
        List<T> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "LayuiGridData(pages=" + this.getPages() + ", page=" + this.getPage() + ", total=" + this.getTotal() + ", data=" + this.getData() + ")";
    }

    public LayuiGridData() {
    }
}

