/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.framework.aspect;

import cn.smarthse.common.redis.utils.RedisUtils;
import cn.smarthse.core.framework.annotation.RequestLimit;
import cn.smarthse.core.framework.model.ResponseStateEnum;
import cn.smarthse.core.framework.utils.StringUtils;
import cn.smarthse.core.framework.utils.login.JwtUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.smarthse.framework.exception.ServiceException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;

@Component
@Aspect
public class RequestLimitAspect {
    private static final Logger log = LoggerFactory.getLogger(RequestLimitAspect.class);

    @Before(value="@annotation(cn.smarthse.core.framework.annotation.RequestLimit)")
    public void logBefor(JoinPoint joinPoint) {
        String spelValue;
        HttpServletRequest request;
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Object[] args = joinPoint.getArgs();
        Method method = signature.getMethod();
        RequestLimit anno = method.getAnnotation(RequestLimit.class);
        if (anno != null && this.isLimit(request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest(), anno, spelValue = this.invokeExpression(method, args, anno.expression()))) {
            throw new ServiceException(ResponseStateEnum.RequestLimit.getValue(), anno.msg(), null);
        }
    }

    public static void renderString(HttpServletResponse response, String string) {
        response.setStatus(HttpStatus.OK.value());
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.setContentType("application/json;charset=UTF-8");
        try (PrintWriter writer = response.getWriter();){
            writer.print(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isLimit(HttpServletRequest request, RequestLimit RepeatUrlFormData, String param) {
        if (request instanceof StandardMultipartHttpServletRequest) {
            return false;
        }
        Long userId = JwtUtil.getUserId();
        String servletPath = request.getServletPath();
        String limitKey = String.format("LIMIT:%s:%s:%s", userId, servletPath, param);
        Integer count = (Integer)RedisUtils.getCacheObject((String)limitKey);
        if (count == null) {
            RedisUtils.setCacheObject((String)limitKey, (Object)1, (Duration)Duration.ofSeconds(RepeatUrlFormData.second()));
        } else {
            if (count >= RepeatUrlFormData.maxCount()) {
                return true;
            }
            RedisUtils.setCacheObject((String)limitKey, (Object)(count + 1), (Duration)Duration.ofSeconds(RepeatUrlFormData.second()));
        }
        return false;
    }

    private String invokeExpression(Method method, Object[] args, String expression) {
        if (StringUtils.isEmpty((CharSequence)expression)) {
            return null;
        }
        StandardEvaluationContext context = new StandardEvaluationContext();
        LocalVariableTableParameterNameDiscoverer discoverer = new LocalVariableTableParameterNameDiscoverer();
        String[] parameterNames = discoverer.getParameterNames(method);
        try {
            if (parameterNames != null) {
                for (int i = 0; i < parameterNames.length; ++i) {
                    context.setVariable(parameterNames[i], args[i]);
                }
            }
        }
        catch (Exception e) {
            log.error("invokeExpression\uff1a", (Throwable)e);
        }
        return String.valueOf(new SpelExpressionParser().parseExpression(expression).getValue((EvaluationContext)context));
    }
}

