package cn.smarthse.core.framework.utils;

import cn.hutool.core.date.LocalDateTimeUtil;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;

/**
 * 风险日期工具
 */

public class RiskTimeUtil implements Serializable {

    public static LocalDate getExpirationDate(LocalDate startTime, Integer effective, Integer effectiveType){
        if(effectiveType == 1){
            return LocalDateTimeUtil.offset(startTime.atStartOfDay(), effective, ChronoUnit.YEARS).toLocalDate();
        }else if(effectiveType == 0){
            return LocalDateTimeUtil.offset(startTime.atStartOfDay(), effective, ChronoUnit.MONTHS).toLocalDate();
        }else {
            return null;
        }
    }
}
