package cn.smarthse.core.framework.utils;

import cn.hutool.core.util.DesensitizedUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.Method;
import java.util.List;


@Slf4j
public class RhoIdCardUtil {
    public static void desensitizeIdCard(Object o, Class clazz) {
        Method getIdcardMethod = ReflectUtil.getMethod(o.getClass(), "getIdcard");
        getIdcardMethod = getIdcardMethod == null ? ReflectUtil.getMethod(o.getClass(), "getIdCard") : getIdcardMethod;

        if(getIdcardMethod == null){
            return;
        }
        Object invoke = ReflectUtil.invoke(o, getIdcardMethod);
        if(invoke == null){
            return;
        }

        String idcard = (String) invoke;
        String result = RhoIdCardUtil.desensitizeIdCard(idcard);


        Method setIdcardMethod = ReflectUtil.getMethod(o.getClass(), "setIdcard", String.class);
        setIdcardMethod = setIdcardMethod == null ? ReflectUtil.getMethod(o.getClass(), "setIdCard", String.class) : setIdcardMethod;
        if(setIdcardMethod == null){
            return;
        }
        ReflectUtil.invoke(o, setIdcardMethod,result);
    }


    public static String desensitizeIdCard(String idCard) {
        String desensitizationIdCard = null;
        if(StrUtil.isNotBlank(idCard)){
            //脱敏处理
            boolean validCard = IdcardUtil.isValidCard(idCard);
            if(validCard && StrUtil.length(idCard) == 18){
                desensitizationIdCard = DesensitizedUtil.idCardNum(idCard,3,3);
            }else {
                int length = StrUtil.length(idCard);
                if(length >= 3){
                    desensitizationIdCard = DesensitizedUtil.idCardNum(idCard,1,1);
                }else {
                    desensitizationIdCard = StrUtil.subPre(idCard, 1) + "***";
                }
            }
        }else {
            desensitizationIdCard = null;
        }

        return desensitizationIdCard;
    }



}
