package cn.smarthse.core.framework.utils;

import java.util.List;

public class FileContentTypeUtils {

    /**
     * 根据文件扩展名获取contenType值
     * @author liaoly
     * @date 2022/3/10 9:47
     * @param FilenameExtension 文件扩展名
     * @return {@link String}
     */
    public static String contentType(String FilenameExtension) {
        if (FilenameExtension.toUpperCase().contains(".BMP")) {
            return "image/bmp";
        }
        if (FilenameExtension.toUpperCase().contains(".GIF")) {
            return "image/gif";
        }
        if (FilenameExtension.toUpperCase().contains(".JPEG")
                || FilenameExtension.toUpperCase().contains(".JPG")
                || FilenameExtension.toUpperCase().contains(".PNG")) {
            return "image/jpeg";
        }
        if (FilenameExtension.toUpperCase().contains(".HTML")) {
            return "text/html";
        }
        if (FilenameExtension.toUpperCase().contains(".TXT")) {
            return "text/plain";
        }
        if (FilenameExtension.toUpperCase().contains(".VSD")) {
            return "application/vnd.visio";
        }
        if (FilenameExtension.toUpperCase().contains(".PPTX")
                || FilenameExtension.toUpperCase().contains(".PPT")) {
            return "application/vnd.ms-powerpoint";
        }
        if (FilenameExtension.toUpperCase().contains(".DOCX")
                || FilenameExtension.toUpperCase().contains(".DOC")) {
            return "application/msword";
        }
        if (FilenameExtension.toUpperCase().contains(".XML")) {
            return "text/xml";
        }
        if (FilenameExtension.toUpperCase().contains(".PDF")) {
            return "application/pdf";
        }
        return null;
    }

    public static String imgTypeValid(String dataPrix) {
        if ("data:image/jpeg;".equalsIgnoreCase(dataPrix)) {
            return ".jpeg";
        } else if ("data:image/jpg;".equalsIgnoreCase(dataPrix)) {
            return ".jpg";
        } else if ("data:image/gif;".equalsIgnoreCase(dataPrix)) {
            return ".gif";
        } else if ("data:image/png;".equalsIgnoreCase(dataPrix)) {
            return ".png";
        } else if ("data:image/apng;".equalsIgnoreCase(dataPrix)) {
            return ".apng";
        } else if ("data:image/svg;".equalsIgnoreCase(dataPrix)) {
            return ".svg";
        } else if ("data:image/bmp;".equalsIgnoreCase(dataPrix)) {
            return ".bmp";
        }
        return null;
    }

    public static String fileTypeValid(String dataPrix) {
        if ("data:text/plain;".equalsIgnoreCase(dataPrix)) {
            return ".txt";
        }
        return null;
    }

    /**
     * 校验文件上传支持的文件类型，支持返回true，反之返回false
     * @param supportFileTypes 支持的文件后缀
     * @param fileName 当前文件名（包含文件后缀）
     * @return {@link boolean}
     * @author liaoly
     * @date 2023/8/23 11:27
     */
    public static boolean checkSupportFileTypes(List<String> supportFileTypes, String fileName) {

        return supportFileTypes != null && supportFileTypes.size() > 0 && fileName != null
                && supportFileTypes.contains(fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase());
    }
}
