package cn.smarthse.core.framework.utils;

import org.springframework.beans.BeanUtils;

import javax.smarthse.framework.exception.ServiceException;
import java.beans.PropertyDescriptor;

/**
 * @JDK_Vserion 1.8
 * @Author DengLibin
 * @Email dlb@smarthse.cn
 * @Desc 字段检查工具类
 * @since 2020/3/17 0017 16:55
 */
public class FieldCheckUtils {

    private FieldCheckUtils() {
    }

    /**
     * 空字段检查
     *
     * @param javaBean
     * @param propertyNames
     * @throws Exception
     */
    public static void checkEmptyFields(Object javaBean, String... propertyNames) throws ServiceException {

        if (javaBean == null) {
            throw new ServiceException("参数不能为空");
        }
        for (String fieldName : propertyNames) {

            String fieldNameCh = fieldName.indexOf('|') == -1 ? fieldName : fieldName.substring(fieldName.indexOf('|') + 1);
            fieldName = fieldName.indexOf('|') == -1 ? fieldName : fieldName.substring(0, fieldName.indexOf('|'));

            PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor(javaBean.getClass(), fieldName);
            Object result = null;
            try {
                result = propertyDescriptor.getReadMethod().invoke(javaBean);
            } catch (Exception e) {
                throw new RuntimeException(e);
            }

            if (result == null) {
                throw new ServiceException( fieldNameCh + "不能为空");
            }
            if (result instanceof String) {
                if (((String) result).length() == 0) {
                    throw new ServiceException(fieldNameCh + "不能为空");
                }
            }
        }
    }

    /**
     * 参数值合法性检测
     *
     * @param javaBean
     * @param propertyName 属性名
     * @param legalValues  该属性 合法值
     * @throws Exception
     */
    public static void checkIllegalValue(Object javaBean, String propertyName, Object... legalValues) throws ServiceException {
        if (javaBean == null) {
            throw new ServiceException("参数不能为空");
        }
        PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor(javaBean.getClass(), propertyName);
        Object result = null;
        try {
            result = propertyDescriptor.getReadMethod().invoke(javaBean);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (Object legalValue : legalValues) {
            if (legalValue.equals(result)) {
                return;
            }
        }
        throw new ServiceException(propertyName + "字段值非法");

    }

}
