package cn.smarthse.core.framework.utils;

import cn.smarthse.core.framework.Constant;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.shiro.crypto.hash.Sha256Hash;

/**
 * @author lixiao
 * @date 2019/7/31 17:11
 */
public class CommonsUtils {

	/**
	 * 获取六位数验证码
	 * @return 验证码
	 */
	public static int getCode() {
		return ThreadLocalRandom.current().nextInt(100000, 999999);
	}

	/**
	 * 使用SHA256加密
	 * @param password 需要加密的密码 md5 32位小写
	 * @param salt 盐值
	 * @return 返回加密后的密码
	 */
	public static String encryptPassword(String password, String salt) {
		return String.valueOf(new Sha256Hash(password, salt, Constant.Password.HASH_ITERATIONS));
	}

}
