package cn.smarthse.core.framework.uploader;



/**
 * 
 * 《上传路径枚举》
 * 
 * 
 * @Project:  smarthse-common1.0
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-6-19-上午11:08:44
 */
public enum UploadFilePathEnum  {
	// 路径说明，考虑避免可能会有/ \路径在不同系统环境下出问题，暂时统一以根路径为准
	Common(0, "通用文件", "common"),
	FACE_AUTH(0, "人脸认证", "faceAuth"),
	CERT(2, "证书", "cert"),
	;
	/** 编码 */
	private int code;

	/** 描述说明 */
	private String desc;
	/** 路径 */
	private String path;

	UploadFilePathEnum(int code, String desc , String path) {
		this.code = code;
		this.path = path;
		this.desc = desc;
	}

	public int getCode() {
		return code;
	}

	public String getDesc() {
		return desc;
	}
	
	
	/**
	 * @return the path
	 */
	public String getPath() {
		return path;
	}


    public static UploadFilePathEnum getCode(int code){
    	for (UploadFilePathEnum c : UploadFilePathEnum.values()) {
			if (c.getCode() == code) {
				return c;
			}
		}
    	
    	return UploadFilePathEnum.Common;
    }

}
