package cn.smarthse.core.framework.uploader;

import cn.hutool.core.util.RandomUtil;
import cn.hutool.extra.servlet.ServletUtil;
import cn.smarthse.core.framework.Constant;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

/**
 * 《上传工具类》
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/4/1 13:54
 */
public class FileUploadSimple {

    public static void transferTo(MultipartFile fileData, String realPath) {
        //文件不存在则创建
        if (!Files.exists(new File(realPath).toPath())) {
            try {
                Files.createDirectories(new File(realPath).toPath());
                fileData.transferTo(new File(realPath));
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /**
     * pluploader上传 保存到本地
     *
     * @param up -
     * @return {@link UploadFileParameter}
     * @author liaoly
     * @date 2022/4/1 13:54
     */
    public static UploadFileParameter upload_pluploader(UploadFileParameter up) {

        try {
            HttpServletRequest request = up.getRequest();
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;

            if (up.getMultipartFile() == null || up.getMultipartFile().getSize() == 0) {
                //读取表单内容
                MultipartFile file = multipartRequest.getFile("file");
                if (file != null && file.getSize() > 0) {
                    up.setMultipartFile(file);
                }
            }
            if (up.getMultipartFile() == null || up.getMultipartFile().getSize() == 0) {
                up.setUploadState(UploadState.UPLOAD_ZEROSIZE);
                return up;
            }

            // 完整的上传路径
            String realPath = up.getRealPath()
                    + UploadFileParameter.FILE_PATH_SEP;

            // 创建目录
            File frealPath = new File(realPath);

            frealPath.mkdirs();

            // 源文件名(包含扩展名)
            String resourceFileName = up.getMultipartFile().getOriginalFilename();
            //设置源文件名(带扩展名) FilenameUtils.getBaseName(resourceFileName)
            int length = resourceFileName.length();
            up.setOriginalFilename(length > Constant.MAX_FILE_NAME_LENGTH ?
                    resourceFileName.substring(length - Constant.MAX_FILE_NAME_LENGTH, length) : resourceFileName);
            //文件hash值
            up.setHashCode(FileMD5.getFileMD5(up.getMultipartFile().getBytes()));
            // 文件大小
            up.setFilesize(up.getMultipartFile().getSize());
            // 文件扩展名
            up.setFileExt(FilenameUtils.getExtension(resourceFileName));
            // 服务端（OSS端）文件名
            up.setFileName(getNumberName(resourceFileName, up.getFileExt()));
            // 服务端文件
            up.setFile(new File(realPath + up.getFileName()));
            // 服务端路径
            up.setRealPath(realPath);
            //oss相对路径(和本地相对路径一至)
            up.setOssUrl((up.getUploadDir() + "/" + up.getFileName()).replace("\\", "/"));
            //oss存储路径
            up.setOssDir(up.getUploadDir().replace("\\", "/"));
            //上传文件终端ip
            up.setIp(ServletUtil.getClientIP(request));

            //保存到本地
            FileUtils.copyToFile(up.getMultipartFile().getInputStream(), up.getFile());
            up.setUploadState(UploadState.UPLOAD_SUCCSSS);

        } catch (Exception e) {
            e.printStackTrace();
        }
        return up;
    }

    //file 转换为 MultipartFile
    public static MultipartFile getMulFileByPath(String filePath) {
        FileItemFactory factory = new DiskFileItemFactory(16, null);
        String textFieldName = "textField";
        int num = filePath.lastIndexOf(".");
        String extFile = filePath.substring(num);
        FileItem item = factory.createItem(textFieldName, "text/plain", true,
                "MyFileName" + extFile);
        File newfile = new File(filePath);
        int bytesRead = 0;
        byte[] buffer = new byte[8192];
        try {
            FileInputStream fis = new FileInputStream(newfile);
            OutputStream os = item.getOutputStream();
            while ((bytesRead = fis.read(buffer, 0, 8192))
                    != -1) {
                os.write(buffer, 0, bytesRead);
            }
            os.close();
            fis.close();
        } catch (IOException e) {
            e.printStackTrace();
        }

        return new CommonsMultipartFile(item);
    }

    /**
     * 用当前日期作为文件路径 yyyy/MM/dd
     * @return 文件路径
     * @author zhaowei
     */
    public static String getDataSplitPath() {

        return new SimpleDateFormat("yyyy" + File.separator + "MM" + File.separator +  "dd").format(new Date());
    }

    /**
     * 用当前日期作为文件路径 yyyyMMdd
     * @return 文件路径
     * @author zhaowei
     */
    public static String getDataPath() {

        return new SimpleDateFormat("yyyyMMdd").format(new Date());
    }

    /**
     * 用当前月份作为文件路径 yyyyMM
     * @return 文件路径
     * @author zhaowei
     */
    public static String getMonthPath() {

        return new SimpleDateFormat("yyyyMM").format(new Date());
    }

    /**
     * <b>function:</b> 用当前日期、时间和1000以内的随机数组合成的文件名称 2212141631340001
     *
     * @param defalutExds 文件后缀
     * @return 新文件名称
     * @author zhaowei
     */
    public static String getNumberName(String defalutExds) {
        SimpleDateFormat format = new SimpleDateFormat("yyMMddHHmmss");
        int rand = new Random().nextInt(1000);
        String numberName = format.format(new Date()) + rand;
        return numberName + "." + defalutExds;
    }

    /**
     * <b>function:</b> 用当前日期、时间和1000以内的随机数组合成的文件名称
     *
     * @param fileName 文件名称
     * @return 新文件名称
     * @author zhaowei
     */
    public static String getNumberName(String fileName, String defalutExds) {
        SimpleDateFormat format = new SimpleDateFormat("yyMMddhhmmss");
        int rand = new Random().nextInt(1000);
        String numberName = format.format(new Date()) + rand;
        return getNewFileName(fileName, numberName, defalutExds);
    }

    /**
     * <b>function:</b> 用当前日期、时间、2位字符串数组合成的文件夹名称
     *
     * @return 新文件名称
     * @author zhaowei
     */
    public static String getNumberFile() {

        return new SimpleDateFormat("HHmmss").format(new Date()) + RandomUtil.randomNumbers(2);
    }

    /**
     * <b>function:</b> 传递一个文件名称和一个新名称，组合成一个新的带后缀文件名 当传递的文件名没有后缀，会添加默认的后缀
     *
     * @param fileName   文件名称
     * @param newName    新文件名称
     * @param nullSuffix 为没有后缀的文件所添加的后缀;eg:txt
     * @return String 文件名称
     * @author zhaowei
     */
    public static String getNewFileName(String fileName, String newName, String nullSuffix) {
        //读取文件名中的扩展名
        String suffix = FilenameUtils.getExtension(fileName);
        if (suffix != null) {
            newName = newName.concat(".").concat(suffix);
        } else {
            newName = newName.concat(".").concat(nullSuffix);
        }
        return newName;
    }
}