package cn.smarthse.core.framework.uploader;

/**
 *
 *  传文件来源哪个系统
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/3/9 15:44
 */
public enum FileResourceEnum {

	platform_01(1, "platform", "云平台"),

	platformAdmin_02(2, "platformAdmin", "运营后台"),

	healthAdvisor_03(3, "healthAdvisor", "健康顾问"),

	thirdOrg_04(4, "thirdOrg", "服务机构"),

	supervise_05(5, "supervise", "监管端"),

	giianAdmin_06(6, "giianAdmin", "建安官网后台"),

	companyHealth_07(7, "companyHealth", "职业卫生企业版"),

	radiation_training(8, "radiationTraining", "放射培训系统"),

	company_impl_9(9, "companyImpl", "企业端实施版"),

	TOWNSHIP_MANAGE(12, "townShipManage", "乡镇协管（浙里卫企）"),

	FWGJ(13, "fwgj", "服务管家（浙里卫企）"),

	WQYY(14, "wqyy", "卫企预约（浙里卫企）"),

	DY(15, "dy", "东阳（浙里卫企）"),

	THROUGHTRAIN(16, "tt", "卫企直通车"),

	rho_supervise(21, "rho_supervise", "放射卫生在线-监管端"),

	rho_company(22, "rho_company", "放射卫生在线-企业端"),

	;
	
	/**
	 * key
	 */
	private final int value;
	
	/**
	 * 编码
	 */
	private final String code;
	
	/**
	 * 中文描述
	 */
	private final String name;
	
	FileResourceEnum(int value, String code, String name) {
		
		this.value = value;
		this.code = code;
		this.name = name;
	}

	public int getValue() {
		return value;
	}

	public String getName() {
		return name;
	}
	
	public String getCode() {
		return code;
	}
	
    public static FileResourceEnum getFileResourceEnum(int value){
    	for (FileResourceEnum c : FileResourceEnum.values()) {
			if (c.getValue() == value) {
				return c;
			}
		}
		return null;
    }
    
    /**
	 * 得到velue的name 
	 * @param value : value
	 * @return String
	 */
	public static String getName(int value) {
		for (FileResourceEnum c : FileResourceEnum.values()) {
			if (c.getValue() == value) {
				return c.name;
			}
		}
		return null;
	}
	
	/**
	 * 得到velue的name 
	 * @param value : value
	 * @return String
	 */
	public static String getCode(int value) {
		for (FileResourceEnum c : FileResourceEnum.values()) {
			if (c.getValue() == value) {
				return c.code;
			}
		}
		return null;
	}
}
