package cn.smarthse.core.framework.service;

import cn.smarthse.core.framework.Constant;
import cn.smarthse.core.framework.dao.BaseMapper;
import cn.smarthse.core.framework.model.BaseEntity;

import java.time.LocalDateTime;

/**
 * 业务基础service实现
 *
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2023/12/15 13:15
 */
public abstract class ServiceImpl<M extends BaseMapper<T>, T> extends com.baomidou.mybatisplus.extension.service.impl.ServiceImpl<M, T> implements IService<T> {

    /**
     * 设置公共字段
     *
     * @param record   当前实体类对象
     * @param createBy 当前账号id （token获取）
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2024/3/8 14:59
     */
    protected void setCreateInfo(BaseEntity record, Long createBy) {
        record.setCreateBy(createBy);
        record.setCreateDate(LocalDateTime.now());
        record.setIsValid(Constant.ACTIVE_YES);
    }

    /**
     * 设置公共字段
     *
     * @param record   当前实体类对象
     * @param updateBy 当前账号id （token获取）
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2024/3/8 14:59
     */
    protected void setUpdateInfo(BaseEntity record, Long updateBy) {
        record.setUpdateBy(updateBy);
        record.setUpdateDate(LocalDateTime.now());
    }
}
