package cn.smarthse.core.framework.mybatis;

import cn.smarthse.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 修改记录对象
 *
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2024/4/9 15:58
 */
@EqualsAndHashCode(callSuper = false)
@TableName(value = "sys_change_log")
@Data
public class SysChangeLog extends BaseEntity implements Serializable {

    private static final long serialVersionUID = -1L;

    @TableId
    private Long id;
    private Long cid;

    @ApiModelProperty("操作账号id")
    private Long userId;

    @ApiModelProperty("操作账号")
    private String username;

    @ApiModelProperty("被编辑数据id")
    private Long dataId;

    @ApiModelProperty("操作类型（insert、update、delete）")
    private String tableName;

    @ApiModelProperty("表名")
    private String operation;

    @ApiModelProperty("字段名称中文")
    private String fieldName;

    @ApiModelProperty("字段名称en")
    private String fieldValue;

    @ApiModelProperty("修改前字段值")
    private String beforeValue;

    @ApiModelProperty("修改后字段值")
    private String afterValue;

    @ApiModelProperty("修改内容")
    private String content;

    @ApiModelProperty("修改时间")
    private LocalDateTime editTime;

    @ApiModelProperty("编辑批次编码（用于标记那些字段是一起编辑的）")
    private Long batchCode;

    @ApiModelProperty("data_id对应名称")
    @TableField(exist = false)
    private String dataName;

}
