package cn.smarthse.core.framework.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 操作账号信息（编辑数据接口的参数类可继承此类）
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/3/11 15:33
 */
@Data
public class UserEditParam implements Serializable {

    private static final long serialVersionUID = 5646651865408074350L;

    /**
     * 线上特殊账号
     */
    @ApiModelProperty(value = "线上特殊账号", hidden = true)
    private Boolean isOnlineSpecialTestUser;

    /**
     * 用户行政区划id
     */
    @ApiModelProperty(value = "操作账号id", hidden = true)
    @JsonIgnore //jackson 序列化和反序列化 字段
    @JSONField(serialize = false) //fastjson 序列化 忽略字段
    private Long loginUserId;

    @ApiModelProperty(value = "操作账号昵称", hidden = true)
    @JsonIgnore
    @JSONField(serialize = false)
    private String loginName;

    @ApiModelProperty(value = "操作账号", hidden = true)
    @JsonIgnore
    @JSONField(serialize = false)
    private String loginUsername;

    /**
     * 用户行政区划id
     */
    @ApiModelProperty(value = "操作账号(监管用户areaId)", hidden = true)
    @JsonIgnore
    @JSONField(serialize = false)
    private Long loginAreaId;

    /**
     * 用户行政区划level
     */
    @JsonIgnore
    @JSONField(serialize = false)
    private Integer loginAreaLevel;

    @ApiModelProperty(value = "操作账号类型（UserTypeEnum）", hidden = true)
    @JsonIgnore
    @JSONField(serialize = false)
    private Integer loginUserType;

    @ApiModelProperty(value = "操作账号(单位cid)", hidden = true)
    @JsonIgnore
    @JSONField(serialize = false)
    private Long loginCid;

    @ApiModelProperty(value = "操作账号(切换分院之后的cid)", hidden = true)
    @JsonIgnore
    @JSONField(serialize = false)
    private Long switchCid;

//    /**
//     * 建议直接用 loginCid，操作账号(单位cid，即：切换分院之后的cid)
//     */
//    public Long getCid() {
//        return loginCid;
//    }
//
//    /**
//     * 建议直接用 loginAreaId 操作账号(监管用户areaId)
//     */
//    public Long getAreaId() {
//        return loginAreaId;
//    }

    /**
     * 新增的时候校验分组
     */
    public interface Add {
    }

    /**
     * 更新的时候校验分组
     */
    public interface Update {
    }
}
