package cn.smarthse.core.framework.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;


/**
 * 返回数据公共类
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/2/26 14:33
 */
@ApiModel
@NoArgsConstructor
@Data
public class ResponseData<T> implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 返回的状态枚举
     */
    @ApiModelProperty(value = "状态码", example = "0-操作成功, 1-操作失败,2-警告,400参数不匹配,401-登录失效,403无权限,500服务器出错", required = true, position = -2)
    private Integer state = ResponseStateEnum.success.getValue();

    /**
     * 返回的文字描述
     */
    @ApiModelProperty(value = "返回消息描述", example = "操作成功！", required = true, position = -1)
    private String message = ResponseStateEnum.success.getName();

    /**
     * 返回的结果数据信息
     */
    @ApiModelProperty(value = "泛型数据包")
    private T result;

    /**
     * 构造函数
     *
     * @param state   状态枚举
     * @param message 返回结果的文字描述、消息提醒
     * @param result  : 返回参数对象
     */
    public ResponseData(Integer state, String message, T result) {
        this.state = state;
        this.message = message;
        this.result = result;
    }

    public ResponseData(Integer state, String message) {
        this.state = state;
        this.message = message;
    }

    public ResponseData(Integer state, T result) {
        this.state = state;
        this.message = ResponseStateEnum.getName(state);
        this.result = result;
    }

    public ResponseData(String message, T result) {
        this.message = message;
        this.result = result;
    }

    public ResponseData(T result) {
        this.message = ResponseStateEnum.success.getName();
        this.result = result;
    }

    public ResponseData(String message) {
        this.message = message;
    }

    public ResponseData(Integer state) {
        this(state, ResponseStateEnum.getName(state));
    }

    public void setState(Integer state) {

        this.state = state;
    }

    public static ResponseData<String> success() {

        return new ResponseData<>();
    }

    public static <T> ResponseData<T> success(T result) {

        return new ResponseData<>(ResponseStateEnum.success.getValue(), result);
    }

    public static <T> ResponseData<T> success(String message, T result) {

        return new ResponseData<>(ResponseStateEnum.success.getValue(), message, result);
    }

    public static ResponseData<String> fail() {

        return new ResponseData<>(ResponseStateEnum.fail.getValue());
    }

    public static <T> ResponseData<T> fail(T result) {

        return new ResponseData<>(ResponseStateEnum.fail.getValue(), ResponseStateEnum.fail.getName(), result);
    }

    public static <T> ResponseData<T> fail(String message) {

        return new ResponseData<>(ResponseStateEnum.fail.getValue(), message);
    }

    public static <T> ResponseData<T> fail(String message, T result) {

        return new ResponseData<>(ResponseStateEnum.fail.getValue(), message, result);
    }

}
