package cn.smarthse.core.framework.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 基础查询参数对象
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class PageParam extends LayuiGridParam {

    @ApiModelProperty("关键字")
    private String keyword;

    @ApiModelProperty("查询开始日期")
    private Date beginDate;

    @ApiModelProperty("查询结束日期")
    private Date endDate;

    @ApiModelProperty(value = "单位id")
    private Long cid;

    @ApiModelProperty(value = "行政区划id")
    private Long areaId;

    @ApiModelProperty(value = "行政区划level", hidden = true)
    private Integer level;

    /**
     * null：全部
     * 1：仅显示本级
     * 2：仅显示非本级
     */
    private Integer onlyThisLevel;

    /**
     * CompanyBelongTypeEnum
     */
    @JsonIgnore
    private Integer belongType;

    /**
     * 是否是测试
     */
    private Integer isTest;

    public void setKeyword(String keyword) {
        this.keyword = (keyword == null ? null : keyword.trim());
    }

}
