
package cn.smarthse.core.framework.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * layui 分页参数
 * 网址：https://www.layui.com/demo/table.html
 *
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年9月23日 下午4:21:01
 */
@EqualsAndHashCode(callSuper = true)
public @Data class LayuiGridParam extends UserEditParam implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 搜索随机数
     */
    @ApiModelProperty(hidden = true)
    private long nd;

    /**
     * 页码
     */
    @ApiModelProperty(value = "页码", example = "1")
    private int page;
    /**
     * 每页几条记录
     */
    @ApiModelProperty(value = "每页几条记录", example = "10")
    private int limit;

    /**
     * 用于排序的列名
     */
    @ApiModelProperty(value = "排序字段", example = "id", notes = "用于排序的列名")
    private String sidx;

    /**
     * 排序的方式 asc desc
     */
    @ApiModelProperty(value = "排序方式", example = "asc", notes = "asc升序,desc降序")
    private String sord;

    /**
     * 是否进行count查询
     */
    private Boolean count;

    public LayuiGridParam() {
        this.page = 1;
        this.limit = 10;
        this.count = true;
    }

    @ApiModelProperty(hidden = true)
    public int getOffset() {
        return (this.page - 1) * this.limit;
    }
}
