package cn.smarthse.core.framework.model;

import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 *
 * 带表头的分页查询参数
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2024/6/7 13:37
 */
@EqualsAndHashCode(callSuper = false)
@Data
public class HeadPageParam extends PageParam {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("表头eg：姓名|name,性别|sex,账号|username,手机号|mobile,状态|isForbidenStr")
    private List<String> headList;

    /**
     * 获取表头字段编码 eg：name,sex,username,mobile,isForbidenStr
     * @return {@link List<String>}
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2024/6/7 14:40
     */
    public List<String> headField() {
        //处理headList，去掉中文，保留编码
        List<String> headField = new ArrayList<>();
        if (headList != null) {
            headList.forEach(h -> {
                int beginIndex = h.indexOf("|");
                if (beginIndex != -1) {
                    headField.add(h.substring(beginIndex + 1));
                } else {
                    headField.add(h);
                }
            });
        }
        return headField;
    }
}
