package cn.smarthse.core.framework.model;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 
 * 基础bean
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2022/2/12 23:06
 */
@Getter
@Setter
public class BaseEntity implements Serializable {
	
	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "创建时间", hidden = true)
	@TableField(fill = FieldFill.INSERT)
	private LocalDateTime createDate;

	@ApiModelProperty(value = "更新时间", hidden = true)
	@TableField(fill = FieldFill.INSERT_UPDATE)
	private LocalDateTime updateDate;

	@ApiModelProperty(value = "创建人", hidden = true)
	@TableField(fill = FieldFill.INSERT)
	private Long createBy;

	@ApiModelProperty(value = "更新人", hidden = true)
	@TableField(fill = FieldFill.INSERT_UPDATE)
	private Long updateBy;

	@TableLogic
	@TableField(select = true)
	@ApiModelProperty(value = "是否有效（1-有效；0-无效）", hidden = true)
	private Integer isValid;

}
