package cn.smarthse.core.framework.filter.dubbo;

import cn.smarthse.core.framework.Constant;
import cn.smarthse.core.framework.utils.login.JwtUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.rpc.*;
import org.slf4j.MDC;

/**
 * dubbo拦截，dubbo消费端调用时，设置MDC信息、token信息
 * 1. dubbo.provider.filter: ProviderMdcFilter
 * 2. META-INF/dubbo/org.apache.dubbo.rpc.Filter 文件内容：ProviderMdcFilter=cn.smarthse.xxx.modules.sys.bootstrap.filter.ProviderMdcFilter
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/8/10 17:16
 */
@Slf4j
public class ConsumerMdcFilter implements Filter {

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {

        invocation.setAttachment(Constant.trackId, MDC.get(Constant.trackId));
        invocation.setAttachment(Constant.TOKEN_HEADER_NAME, JwtUtil.getToken());

        // 这里不清除MDC信息，因为CommonFilter会清除MDC信息
        return invoker.invoke(invocation);
    }
}

