package cn.smarthse.core.framework.filter;

import cn.smarthse.core.framework.Constant;
import java.io.IOException;
import java.time.Instant;
import javax.servlet.*;
import org.slf4j.MDC;

/**
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2024/4/10 9:40
 */
public class CommonFilter implements Filter {

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {

        MDC.put(Constant.trackId, String.valueOf(Instant.now().toEpochMilli()));

        try {
            chain.doFilter(request, response);
        } finally {
            MDC.clear();
        }
    }
}
