package cn.smarthse.core.framework.captcha;

import cn.hutool.captcha.generator.AbstractGenerator;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;

public class RandomNumberGenerator extends AbstractGenerator {

    /**
     * 构造
     *
     * @param baseStr 基础字符集合，用于随机获取字符串的字符集合
     * @param length  生成验证码长度
     */
    public RandomNumberGenerator(String baseStr, int length) {
        super(baseStr, length);
    }

    @Override
    public String generate() {
        return RandomUtil.randomString(RandomUtil.BASE_NUMBER, this.length);
    }

    @Override
    public boolean verify(String code, String userInputCode) {
        if (StrUtil.isNotBlank(userInputCode)) {
            return StrUtil.equalsIgnoreCase(code, userInputCode);
        }
        return false;
    }
}
