package cn.smarthse.core.framework.bootstrap.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties("wxpay-config")
@Data
public class WxpayProperties {
	
	//应用ID
	private String appid;
	
	//商户号
	private String mchid;
	
	//商户API证书的证书序列号
	private String merchantSerialNumber;
	
	//商户API私钥，如何加载商户API私钥请看常见问题
	private String merchantPrivateKey;
	
	//微信支付平台证书。你也可以使用后面章节提到的“自动更新证书功能”，而不需要关心平台证书的来龙去脉
	private String wechatpayCertificates;
	
	//apiV3Key是String格式的API v3密钥
	private String apiV3Key;
	
	//网关
	private String gatewayHost;
	
	//回调
	private String notifyUrl;

	// 微信小程序 appid、 appsecret
	private String miniProgramAppid;
	private String miniProgramAppsecret;
}
