package cn.smarthse.core.framework.bootstrap.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

/**
 *
 * 短信配置属性
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2023/4/13 10:51
 */
@ConfigurationProperties("smt")
public @Data class SmtProperties {

    private int trytime = 3;

    /** 默认启用龙卷风短信  default dysmsapi2 */
    private SmtEnum type = SmtEnum.dysmsapi2;

    /** 阿里云短信配置 */
    @NestedConfigurationProperty
    private final Dysmsapi dysmsapi = new Dysmsapi();

    /** 龙卷风短信配置 */
    @NestedConfigurationProperty
    private final DySmsApi2 dysmsapi2 = new DySmsApi2();

    /** 风短枚举 */
    public enum SmtEnum{
        /** 阿里云短信*/
        dysmsapi,
        /** 龙卷风短信*/
        dysmsapi2,
    }

    /** 阿里云短信配置 */
    @Data
    public static class Dysmsapi {
        //产品名称:云通信短信API产品,开发者无需替换
        private String product = "Dysmsapi";

        //产品域名,开发者无需替换
        private String domain = "dysmsapi.aliyuncs.com";

        //此处需要替换成开发者自己的AK(在阿里云访问控制台寻找)
        private String regionid = "cn-hangzhou";

        private String endpointname = "cn-hangzhou";

        private String accesskeyid = "accesskeyid";

        private String accesskeysecret = "accesskeysecret";

        private String signname = "智慧职安环保科技";

        private String templatecode = "SMS_137671605";
    }

    /** 龙卷风短信配置 */
    @Data
    public static class DySmsApi2 {
        //SMT账号
        private  String CORPID = "657412";
        //SMT密码
        private  String PWD = "657412@giian";
        private String ENCODING = "UTF-8";
        //统一签名
        private String MSGSIGN = "【智慧职安环保科技】";
        //通用发送接口的http地址
        private String URI_SEND_SMS = "http://183.131.19.158:7891/mt";
        //群发短信 BatchSend
        private String URI_BATCHSEND_SMS = "http://183.131.19.158:7891/mt";
    }
}
