package cn.smarthse.core.framework.annotation;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;

import java.util.Arrays;

/**
 * 日志模块分类
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/3/4年9:27月日
 */
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum LogModuleTypeEnum {

    // 其它-0
    anon("其他", 0, 0),

    //------------------------------------------------------------------------------------------------------------------

    // 医院端-10000
    com_uc("个人中心", 10000, 1),

    //com_base("基础信息", 10100, 1),
    com_base_company("基础信息-医院基础信息", 10101, 1),
    com_base_staff("基础信息-放射工作人员管理档案", 10102, 1),
    com_base_device("基础信息-医用射线装置/放射性同位素管理档案", 10103, 1),
    com_base_location("基础信息-机房管理", 10104, 1),
    com_base_org("基础信息-组织架构管理", 10105, 1),
    com_base_ray_manage("基础信息-放射防护管理领导小组", 10106, 1),
    com_base_post("基础信息-岗位", 10107, 1),

    //com_keyFactor("关键因素画像", 10200, 1),
    com_keyFactor_license("关键因素画像-许可管理", 10201, 1),
    com_keyFactor_equipment("关键因素画像-设备性能检测", 10202, 1),
    com_keyFactor_radiation("关键因素画像-放射诊疗工作场所检测", 10203, 1),
    com_keyFactor_physical("关键因素画像-职业健康体检", 10204, 1),
    com_keyFactor_train("关键因素画像-放射工作人员培训", 10205, 1),
    //com_keyFactor_dose("关键因素画像-个人剂量监测", 10206, 1),
    com_keyFactor_dose_monitor("关键因素画像-个人剂量监测-个人剂量监测列表", 10207, 1),
    com_keyFactor_dose_overexposure("关键因素画像-个人剂量监测-过量照射调查列表", 10208, 1),
    com_keyFactor_three("关键因素画像-“三同时”管理", 10209, 1),
    com_keyFactor_protective("关键因素画像-个人防护用品", 10210, 1),
    com_keyFactor_safety_device("关键因素画像-安全装置和警示标识", 10211, 1),

    //com_risk("风险化解管理", 10300, 1),
    com_risk_association("风险化解管理-关键因素画像关联风险清单", 10301, 1),
    com_risk_other("风险化解管理-其它风险管理", 10302, 1),

    com_license("许可管理", 10400, 1),

    //com_report("数据报表", 10500, 1),
    com_report_supervision("数据报表-监督数据", 10501, 1),
    com_report_punish("数据报表-处罚数据", 10502, 1),

    com_training("在线培训", 10600, 1),

    //com_online_monitor("在线监测监控", 10700, 1),

    //com_sys("系统管理", 10800, 1),
    com_sys_user("系统管理-账号管理", 10801, 1),
    com_sys_role("系统管理-角色管理", 10802, 1),
    com_sys_log("系统管理-日志管理", 10803, 1),

    com_setting_table("表头设置", 10901, 1),

    //------------------------------------------------------------------------------------------------------------------

    // 监管端-30000
    sup_uc("个人中心", 30000, 3),

    sup_company_archives("医用放射用人单位管理档案", 30100, 3),

    sup_staff_archives("放射工作人员管理档案", 30200, 3),

    //sup_license("医用放射用人单位许可管理", 30300, 3),

    //sup_risk("关键因素画像与风险化解管理", 30400, 3),
    sup_risk_manage("关键因素画像与风险化解管理-关键因素画像审核清单", 30401, 3),
    sup_risk_mitigation("关键因素画像与风险化解管理-风险化解管理清单", 30402, 3),
    sup_risk_complete("关键因素画像与风险化解管理-风险化解完成情况医院清单", 30403, 3),
    sup_risk_warning("关键因素画像与风险化解管理-风险示警清单", 30404, 3),
    sup_risk_other("关键因素画像与风险化解管理-其它风险清单", 30405, 3),

    //sup_online_monitor("在线监测监控管理档案", 30500, 3),
    sup_online_monitor_equipment("在线监测监控管理档案-在线监测监控设备列表", 30501, 3),
    sup_online_monitor_risk("在线监测监控管理档案-智能识别风险化解管理", 30502, 3),

    //sup_statistics("数据报表", 30600, 3),
    sup_statistics_user("数据报表-账号活跃度统计", 30601, 3),
    sup_statistics_supervision("数据报表-监督数据列表", 30602, 3),
    sup_statistics_punish("数据报表-处罚数据列表", 30603, 3),
    sup_statistics_risk("数据报表-医用放射用人单位关键因素画像与风险化解率进度表", 30604, 3),

    //sup_train("职业健康培训管理档案", 30700, 3),
    //sup_train_project("职业健康培训管理档案-职业健康培训列表", 30701, 3),

    //sup_sys("系统管理", 30800, 3),
    sup_sys_company("系统管理-院区管理", 30801, 3),
    sup_sys_companyUser("系统管理-医用放射用人单位用户管理", 30802, 3),
    sup_sys_orgUser("系统管理-监管用户管理", 30803, 3),
    //sup_sys_change("系统管理-医院信息变更管理", 30804, 3),

    sup_setting_table("表头设置", 30901, 3),

    ;

    /**
     * 模块名
     */
    @ApiModelProperty("模块名")
    public final String moduleName;
    /**
     * 模块编码
     */
    @ApiModelProperty("模块编码")
    public final Integer moduleType;
    /**
     * 来源（LogResourceEnum）
     */
    @ApiModelProperty("来源（LogResourceEnum）")
    public Integer resource;

    private LogModuleTypeEnum(String moduleName, Integer moduleType) {
        this.moduleName = moduleName;
        this.moduleType = moduleType;
    }

    private LogModuleTypeEnum(String moduleName, Integer moduleType, Integer resource) {
        this.moduleName = moduleName;
        this.moduleType = moduleType;
        this.resource = resource;
    }

    public static LogModuleTypeEnum getByModuleType(Integer moduleType) {
        for (LogModuleTypeEnum c : LogModuleTypeEnum.values()) {
            if (c.getModuleType().equals(moduleType)) {
                return c;
            }
        }
        return LogModuleTypeEnum.anon;
    }

    public static String getModuleNameByModuleType(Integer moduleType) {

        return getByModuleType(moduleType).getModuleName();
    }

    public static LogModuleTypeEnum[] getByResource(Integer resource) {

        return Arrays.stream(LogModuleTypeEnum.values())
                .filter(c -> resource.equals(c.getResource()))
                .toArray(LogModuleTypeEnum[]::new);
    }

}
