package cn.smarthse.core.framework.annotation;

import cn.smarthse.common.annotation.password.OperatorDataSourceEnum;

import java.lang.annotation.*;

/**
 * 方法级日志拦截器标识
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/2/26 20:21
 */
@Target({ElementType.METHOD})
@Documented
@Retention(RetentionPolicy.RUNTIME)
public @interface Log {

    /**
     * 标题
     *
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2022/2/26 20:22
     */
    String title() default "";

    /**
     * 日志模块
     *
     * @return {@link LogModuleTypeEnum}
     * @author liaoly
     * @date 2022/3/21 11:00
     */
    LogModuleTypeEnum logModule() default LogModuleTypeEnum.anon;

    /**
     * 操作类型
     *
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2022/2/26 20:21
     */
    LogTypeEnum type() default LogTypeEnum.type_opt;

    /**
     * spel表达式，获取方法参数
     *
     * @author liaoly(廖凌云)
     * @date 2023/11/9 15:15
     */
    String expression() default "";

    /**
     * 数据隶属 OperatorDataSourceEnum（0-其它，1-企业端，2-监管端，3-运维端，4-机构端）
     */
    OperatorDataSourceEnum dataOf() default OperatorDataSourceEnum.OTHER;

}
