package cn.smarthse.core.framework;

import cn.hutool.crypto.digest.MD5;

/**
 * @author lixiao
 * @date 2019/10/26 12:03
 */
public class RedisKey {

    /**
     * 分布式锁key
     */
    public static String LOCK_KEY = "LOCK";

    private static final String passwordRetryCacheName = "login:passwordretry:";

    /**
     * 密码错误重试key
     */
    public static String passwordRetry(String username) {
        return "login:passwordretry:" + username;
    }

    /**
     * 分布式锁key
     *
     * @param key 唯一标记
     */
    public static String getLockKey(String key) {
        return LOCK_KEY + key;
    }

    /**
     * 登录验证码
     */
    public static String getLoginCodeKey(String phone) {
        return "login:code:" + phone;
    }

    /**
     * 修改密码验证码
     */
    public static String getModifyPasswordCodeKey(String phone) {
        return "modify:pwd:code:" + phone;
    }

    /**
     * 验证码
     */
    public static String getVCodeKey(String key) {
        return "vcode:" + key;
    }

    /**
     * 登录principal缓存key
     */
    public static String getCompanyLoginUserKey(Long userId) {
        return "login:user:company:" + userId;
    }

    /**
     * 登录principal缓存key
     */
    public static String getSuperviseLoginUserKey(Long userId) {
        return "login:user:supervise:" + userId;
    }

    /**
     * 登录token缓存key
     */
    public static String getCompanyLoginTokenKey(Long userId) {
        return "login:token:company:" + userId;
    }

    /**
     * 登录token缓存key
     */
    public static String getSuperviseLoginTokenKey(Long userId) {
        return "login:token:supervise:" + userId;
    }

    public static String getLoginCidKey(Long userId) {
        return "login:cid:" + userId;
    }

    /**
     * 请求限制key
     */
    public static String getRequestLimitKey(String ip, String servletPath, String param) {
        return "limit:" + MD5.create().digestHex(ip + servletPath + param);
    }

    /**
     * token验签密钥 的缓存key
     */
    public static String getTokenSecret(Long userId) {
        return "token:user:secret:" + userId;
    }

    /**
     * RSA私钥key
     */
    public static String RSA(String uuid) {
        return "RSA:" + uuid;
    }

    /**
     * rw-link-if3 定位设备网关 中间件对接 token
     */
    public static String getRwLinkIf3TokenKey() {
        return "sync:rwLink-accessTokenKey";
    }

    public static String getRwLinkIf3DataKey() {
        return "sync:rwLink-accessDataKey";
    }
}
