package cn.smarthse.core.framework;

import java.time.Duration;
import java.util.concurrent.TimeUnit;

/**
 * 常量类
 *
 * @author liaoly
 * @date 2022/2/11 22:56
 */
public class Constant {

    /**
     * 精度蓝牙定位设备坐标异常数据日统计表日志model
     */
    public static Integer X_PDDS_STA_DAY_LOG_MODEL = 31;


    /**
     * jwtToken过期时间 60min
     */
    public static Long TOKEN_EXPIRE_TIME = TimeUnit.MINUTES.toMillis(60);
    /**
     * redis中的 token缓存有效期30分钟（比jwtToken过期时间长些）
     */
    public static Long REDIS_TOKEN_EXPIRE_TIME = TOKEN_EXPIRE_TIME * 2;
    /**
     * jwtToken距过期剩余时间，默认10min（从token生成开始经过 Xxx 时间后剩余时间小于xxx毫秒后 需要刷新token）
     */
    public static Long REFRESH_TOKEN_BEGIN_TIME_REST = TimeUnit.MINUTES.toMillis(10);
    /**
     * redis中的 principal 对象的缓存有效时长30分钟
     */
    public static Long REDIS_PRINCIPAL_TIME = TimeUnit.MINUTES.toMinutes(30);
    /**
     * token请求头名称
     */
    public static String TOKEN_HEADER_NAME = "token";
    /**
     * refreshToken请求头名称
     */
    public static String REFRESH_TOKEN_HEADER_NAME = "refreshToken";

    /**
     * 链路追踪标记
     */
    public static String trackId = "trackId";

    public static Boolean TRUE = true;

    public static Boolean FALSE = false;

    /**
     * 有效/无效
     */
    public static final Integer ACTIVE_YES = 1;
    public static final Integer ACTIVE_NO = 0;

    /**
     * 权限编码后缀-查看权限
     */
    public static final String permission_view_suffix = ":view";
    /**
     * 权限编码后缀-编辑权限
     */
    public static final String permission_edit_suffix = ":edit";

    /**
     * 文件上传的文件名称 最大长度
     */
    public static final int MAX_FILE_NAME_LENGTH = 128;

    /**
     * 设置ttl以申请缓存项。使用时间。0 声明永久缓存。
     */
    public static final Duration entryTtl = Duration.ofDays(1);

    /**
     * 单点登录签名过期时间/ms
     */
    public static final long cas_expire_time = 600 * 1000;

    /**
     * 密码相关
     */
    public static class Password {
        /**
         * 图形验证码过期时间 此处为五分钟
         */
        public static Integer CODE_EXPIRE_TIME = 5;
        /**
         * 默认密码 Zyj@2022
         */
        public static final String DEFAULT_PWD = "Zyj@2022";
        /**
         * 密码最长有效期90天（超过提示修改密码）
         */
        public static final int MAX_PASSWORD_EXPIRE_DAY = 90;
        /**
         * 密码的盐值长度为 8
         */
        public static final int SALT_SIZE = 8;
        /**
         * 密码hash次数
         */
        public static final int HASH_ITERATIONS = 1024;
    }

    /**
     * 图形验证码
     */
    public static class Vcode {
        /**
         * 图形验证码过期时间 此处为五分钟
         */
        public static Integer CODE_EXPIRE_TIME = 5;
        /**
         * 验证码- 默认长度
         */
        public static final int DEFAULT_LEN = 4;
        /**
         * 验证码- 默认宽度
         */
        public static final int DEFAULT_WIDTH = 130;
        /**
         * 验证码- 默认高度
         */
        public static final int DEFAULT_HEIGHT = 48;
    }
}
