/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.sys.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.framework.redis.utils.RedisUtils;
import cn.smarthse.modules.datacentre.provider.log.ISysOperLogProviderService;
import cn.smarthse.modules.sys.enumd.OperatorDataSourceEnum;
import cn.smarthse.rho.core.framework.Constant;
import cn.smarthse.rho.core.framework.model.BaseEntity;
import cn.smarthse.rho.core.framework.model.IdParam;
import cn.smarthse.rho.core.framework.model.IdsParam;
import cn.smarthse.rho.core.framework.utils.CommonsUtils;
import cn.smarthse.rho.core.framework.utils.Digests;
import cn.smarthse.rho.core.framework.utils.StringUtils;
import cn.smarthse.rho.modules.sys.converter.sys.SysUserConverter;
import cn.smarthse.rho.modules.sys.dao.b.BCompanyMapper;
import cn.smarthse.rho.modules.sys.dao.sys.SysUserMapper;
import cn.smarthse.rho.modules.sys.dao.sys.SysUserRoleMapper;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.sys.SysUser;
import cn.smarthse.rho.modules.sys.entity.sys.SysUserRole;
import cn.smarthse.rho.modules.sys.enums.sys.RhoUserRolesEnum;
import cn.smarthse.rho.modules.sys.enums.user.UserResourceEnum;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyUserAddForComParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyUserCreateEditParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyUserEditForComParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyUserListParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyUserStatueEditByCidListForSupParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyUserStatueEditForComParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyUserStatueEditForSupParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysRoleDto;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysUserCompanyListForComVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysUserCompanyListForSupVo;
import cn.smarthse.rho.modules.sys.service.sys.ISysUserService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.DigestUtils;

@Service
@Transactional(readOnly=true)
public class SysUserServiceImpl
extends ServiceImpl<SysUserMapper, SysUser>
implements ISysUserService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SysUserServiceImpl.class);
    @DubboReference
    private ISysOperLogProviderService sysOperLogService;
    private final SysUserConverter converter;
    private final SysUserRoleMapper sysUserRoleMapper;
    private final BCompanyMapper companyMapper;

    @Override
    public Page<SysUserCompanyListForSupVo> getSysCompanyUserListForSup(SysCompanyUserListParam param) {
        param.setKeywordEn(param.getKeyword());
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<SysUserCompanyListForSupVo> list = ((SysUserMapper)this.baseMapper).getCompanyUserListForSup(param);
        return (Page)list;
    }

    @Override
    public Page<SysUserCompanyListForComVo> getSysCompanyUserListForCom(SysCompanyUserListParam param) {
        param.setKeywordEn(param.getKeyword());
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<SysUserCompanyListForComVo> list = ((SysUserMapper)this.baseMapper).getSysCompanyUserListForCom(param);
        list.stream().peek(i -> i.setRoleList(this.converter.sysRoleVoList2SysRoleDtoList(this.sysUserRoleMapper.selectRoleListByUserId(i.getId())))).collect(Collectors.toList());
        return (Page)list;
    }

    @Override
    @Transactional
    public Boolean updateSysCompanyUserEditForCom(SysCompanyUserEditForComParam param) {
        if (!this.checkUsername(param.getUsername(), param.getId())) {
            throw new ServiceException("\u7528\u6237\u540d\u5df2\u5b58\u5728\uff01");
        }
        SysUser user = this.converter.sysCompanyUserEditForComParam2Entity(param);
        user.setUpdateBy(param.getLoginUserId());
        user.setUpdateDate(LocalDateTime.now());
        if (this.updateById(user)) {
            this.sysUserRoleMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)param.getId()));
            ArrayList<SysUserRole> addUserRoleList = new ArrayList<SysUserRole>();
            for (SysRoleDto role : param.getRoleList()) {
                SysUserRole userRole = new SysUserRole();
                userRole.setUserId(param.getId());
                userRole.setRoleId(role.getRoleId());
                addUserRoleList.add(userRole);
            }
            return CollUtil.isNotEmpty((Collection)this.sysUserRoleMapper.insert(addUserRoleList));
        }
        return false;
    }

    @Override
    @Transactional
    public Boolean updateSysCompanyUserStatueForSup(SysCompanyUserStatueEditForSupParam param) {
        BCompany company = (BCompany)this.companyMapper.selectById(param.getId());
        if (Objects.isNull(company)) {
            throw new ServiceException("\u8be5\u9662\u5df2\u4e0d\u5b58\u5728");
        }
        if (param.getIsForbidden() == 0 && company.getState() == 0) {
            throw new ServiceException("\u542f\u7528\u5931\u8d25\uff0c\u8be5\u9662\u4e3a\u5173\u95ed\u72b6\u6001");
        }
        if (param.getIsForbidden() == 1) {
            return ((SysUserMapper)this.baseMapper).disableExcludeSingleUserIsForbidden(param) > 0;
        }
        param.setIsForbidden(Integer.valueOf(0));
        return ((SysUserMapper)this.baseMapper).updateAdminUserIsForbidden(param) > 0;
    }

    @Override
    @Transactional
    public Boolean updateSysCompanyUserExcludeSingleUserStatueByCidListForSup(SysCompanyUserStatueEditByCidListForSupParam param) {
        if (CollUtil.isEmpty((Collection)param.getIdList())) {
            return false;
        }
        return ((SysUserMapper)this.baseMapper).updateSysCompanyUserExcludeSingleUserStatueByCidListForSup(param);
    }

    @Override
    @Transactional
    public Boolean updateSysCompanyUserStatueForCom(SysCompanyUserStatueEditForComParam param) {
        SysUser exists = (SysUser)this.getById(param.getUserId());
        if (exists == null) {
            throw new ServiceException("\u8be5\u7528\u6237\u5df2\u7ecf\u4e0d\u5b58\u5728\uff01");
        }
        SysUser sysUser = new SysUser();
        sysUser.setId(param.getUserId());
        sysUser.setIsForbidden(param.getIsForbidden());
        sysUser.setUpdateBy(param.getLoginUserId());
        sysUser.setUpdateDate(LocalDateTime.now());
        return this.updateById(sysUser);
    }

    @Override
    @Transactional
    public Boolean resetPassword(IdParam param) {
        SysUser user = (SysUser)this.getById(param.getId());
        if (user == null) {
            throw new ServiceException("\u8be5\u7528\u6237\u5df2\u7ecf\u4e0d\u5b58\u5728\uff01");
        }
        String salt = Digests.salt();
        user.setPassword(this.getPassword(DigestUtils.md5DigestAsHex((byte[])"Zyj@2022".getBytes()), salt));
        user.setSalt(salt);
        user.setChangePwDate(LocalDateTime.now());
        user.setIsDefaultPwd(Integer.valueOf(1));
        user.setUpdateBy(param.getLoginUserId());
        user.setUpdateDate(LocalDateTime.now());
        RedisUtils.deleteObject((String)("global:pwd_err_cnt:" + user.getUsername()));
        return this.updateById(user);
    }

    @Override
    @Transactional
    public boolean delUserByUserId(Long userId, Long adminId) {
        SysUser user = (SysUser)this.getById(userId);
        if (user == null) {
            throw new ServiceException("\u8be5\u7528\u6237\u5df2\u7ecf\u4e0d\u5b58\u5728\uff01");
        }
        Set<String> userRoleCodeList = this.sysUserRoleMapper.selectRolePermissionByUserId(userId);
        if (CollUtil.isNotEmpty(userRoleCodeList) && userRoleCodeList.contains("super_admin")) {
            throw new ServiceException("\u8d85\u7ea7\u7ba1\u7406\u5458\u8d26\u53f7\u4e0d\u80fd\u5220\u9664\uff01");
        }
        return this.removeById(userId);
    }

    @Override
    @Transactional
    public boolean delUserByCid(Long cid, Long adminId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate(SysUser.class);
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(SysUser::getCid, (Object)cid)).eq(BaseEntity::getIsValid, (Object)Constant.ACTIVE_YES)).set(BaseEntity::getIsValid, (Object)Constant.ACTIVE_NO)).set(BaseEntity::getUpdateBy, (Object)adminId)).set(BaseEntity::getUpdateDate, (Object)LocalDateTime.now());
        return this.update((Wrapper)wrapper);
    }

    @Override
    @Transactional
    public boolean delUserByCidList(List<Long> cidList, Long adminId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate(SysUser.class);
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.in(SysUser::getCid, cidList)).eq(BaseEntity::getIsValid, (Object)Constant.ACTIVE_YES)).set(BaseEntity::getIsValid, (Object)Constant.ACTIVE_NO)).set(BaseEntity::getUpdateBy, (Object)adminId)).set(BaseEntity::getUpdateDate, (Object)LocalDateTime.now());
        return this.update((Wrapper)wrapper);
    }

    @Override
    @Transactional
    public boolean delUserExcludeSingleUserByCidList(IdsParam param) {
        if (CollUtil.isEmpty((Collection)param.getIdList())) {
            return false;
        }
        List list = this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysUser.class).and(i -> i.in(SysUser::getCid, (Collection)param.getIdList()))).eq(BaseEntity::getIsValid, (Object)Constant.ACTIVE_YES));
        if (CollUtil.isEmpty((Collection)list)) {
            return false;
        }
        param.setIdList(list.stream().map(SysUser::getCid).collect(Collectors.toList()));
        return ((SysUserMapper)this.baseMapper).delUserExcludeSingleUserByCidList(param);
    }

    @Override
    public SysUser getUserById(Long userId) {
        return ((SysUserMapper)this.baseMapper).getUserById(userId);
    }

    @Override
    public SysUser getManagerUserByCid(Long cid) {
        return ((SysUserMapper)this.baseMapper).getManagerUserByCid(cid);
    }

    @Override
    public List<SysUser> getUserListByCid(Long cid) {
        QueryWrapper wrapper = Wrappers.query();
        ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"cid", (Object)cid)).eq((Object)"is_valid", (Object)Constant.ACTIVE_YES)).last("limit 1");
        return this.list((Wrapper)wrapper);
    }

    @Override
    public SysUser getUserByUsername(String username) {
        QueryWrapper wrapper = Wrappers.query();
        ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"username", (Object)SpringEncryptUtils.encrypt((String)username))).eq((Object)"is_valid", (Object)Constant.ACTIVE_YES)).last("limit 1");
        return (SysUser)this.getOne((Wrapper)wrapper);
    }

    @Override
    @Transactional(isolation=Isolation.SERIALIZABLE)
    public SysUser addUserForSuperCas(Long cid, String username, String nickname, Long roleId) {
        SysUser sysUser = this.getUserByUsername(username);
        if (ObjectUtil.isNotNull((Object)sysUser)) {
            return sysUser;
        }
        SysUser entity = new SysUser();
        entity.setId(null);
        entity.setCid(cid);
        entity.setUsername(username);
        entity.setNickname(nickname);
        entity.setResource(UserResourceEnum.SUPERVISE_SINGLE_ADD.getValue());
        String salt = Digests.salt();
        entity.setPassword(this.getPassword(DigestUtils.md5DigestAsHex((byte[])"Zyj@2022".getBytes()), salt));
        entity.setForbiddenUpdateTime(LocalDateTime.now());
        entity.setIsDefaultPwd(Integer.valueOf(0));
        entity.setTimedPasswordReset(Integer.valueOf(0));
        entity.setTwoFactorCheck(Byte.valueOf((byte)1));
        entity.setSalt(salt);
        this.save(entity);
        SysUserRole userRole = new SysUserRole();
        userRole.setUserId(entity.getId());
        userRole.setRoleId(roleId);
        this.sysUserRoleMapper.insert(userRole);
        return entity;
    }

    @Override
    @Transactional(isolation=Isolation.SERIALIZABLE)
    public Boolean addUserForSup(SysCompanyUserCreateEditParam param) {
        if (!this.checkUsername(param.getBranchName(), null)) {
            throw new ServiceException("\u7528\u6237\u540d\u5df2\u5b58\u5728\uff01");
        }
        SysUser sysUser = new SysUser();
        sysUser.setCid(param.getId());
        sysUser.setUsername(param.getBranchName());
        sysUser.setNickname(param.getBranchName());
        String salt = Digests.salt();
        sysUser.setResource(UserResourceEnum.SUPERVISE_ADD.getValue());
        sysUser.setPassword(this.getPassword(DigestUtils.md5DigestAsHex((byte[])"Zyj@2022".getBytes()), salt));
        sysUser.setForbiddenUpdateTime(LocalDateTime.now());
        sysUser.setSalt(salt);
        sysUser.setCreateBy(param.getLoginUserId());
        sysUser.setCreateDate(LocalDateTime.now());
        ((SysUserMapper)this.baseMapper).insert(sysUser);
        SysUserRole userRole = new SysUserRole();
        userRole.setUserId(sysUser.getId());
        userRole.setRoleId(RhoUserRolesEnum.RHO_COMPANY_SUPER_ADMIN.getRoleId());
        return this.sysUserRoleMapper.insert(userRole) > 0;
    }

    @Override
    @Transactional(isolation=Isolation.SERIALIZABLE)
    public Boolean addUserByCidListForSup(IdsParam param) {
        if (CollUtil.isEmpty((Collection)param.getIdList())) {
            return false;
        }
        List companies = this.companyMapper.selectList((Wrapper)Wrappers.lambdaQuery(BCompany.class).in(BCompany::getId, (Collection)param.getIdList()));
        if (CollUtil.isEmpty((Collection)companies)) {
            return false;
        }
        Long loginUserId = param.getLoginUserId();
        String defaultPassword = DigestUtils.md5DigestAsHex((byte[])"Zyj@2022".getBytes());
        ArrayList<SysUser> userList = new ArrayList<SysUser>();
        ArrayList<SysUserRole> userRoleList = new ArrayList<SysUserRole>();
        for (BCompany company : companies) {
            String username = company.getName();
            if (!this.checkUsername(username, null)) continue;
            String salt = Digests.salt();
            SysUser sysUser = new SysUser();
            sysUser.setCid(company.getId());
            sysUser.setUsername(username);
            sysUser.setNickname(username);
            sysUser.setResource(UserResourceEnum.SUPERVISE_ADD.getValue());
            sysUser.setPassword(this.getPassword(defaultPassword, salt));
            sysUser.setSalt(salt);
            sysUser.setForbiddenUpdateTime(LocalDateTime.now());
            sysUser.setCreateBy(loginUserId);
            sysUser.setCreateDate(LocalDateTime.now());
            userList.add(sysUser);
            SysUserRole userRole = new SysUserRole();
            userRole.setRoleId(RhoUserRolesEnum.RHO_COMPANY_SUPER_ADMIN.getRoleId());
            userRoleList.add(userRole);
        }
        if (CollUtil.isEmpty(userList)) {
            return false;
        }
        boolean userInserted = this.saveBatch(userList);
        if (userInserted) {
            for (int i = 0; i < userList.size(); ++i) {
                ((SysUserRole)userRoleList.get(i)).setUserId(((SysUser)userList.get(i)).getId());
            }
            return CollUtil.isNotEmpty((Collection)this.sysUserRoleMapper.insert(userRoleList));
        }
        return false;
    }

    @Override
    @Transactional(isolation=Isolation.SERIALIZABLE)
    public void addUserForWanda(Long cid, String branchName, Long LoginUserId, String medicalNucode) {
        if (cid == null || medicalNucode == null) {
            throw new ServiceException("\u6ce8\u518c\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (((SysUserMapper)this.baseMapper).hasCmAccount(medicalNucode)) {
            return;
        }
        if (((SysUserMapper)this.baseMapper).hasCmAccountByCompanyName(branchName)) {
            return;
        }
        SysUser sysUser = new SysUser();
        sysUser.setCid(cid);
        sysUser.setMedicalNucode(medicalNucode);
        sysUser.setUsername(branchName);
        sysUser.setNickname(branchName);
        String salt = Digests.salt();
        sysUser.setResource(UserResourceEnum.WANDA_SYNC_ADD.getValue());
        sysUser.setPassword(this.getPassword(DigestUtils.md5DigestAsHex((byte[])"Zyj@2022".getBytes()), salt));
        sysUser.setSalt(salt);
        sysUser.setForbiddenUpdateTime(LocalDateTime.now());
        sysUser.setCreateBy(LoginUserId);
        sysUser.setCreateDate(LocalDateTime.now());
        ((SysUserMapper)this.baseMapper).insert(sysUser);
        SysUserRole userRole = new SysUserRole();
        userRole.setUserId(sysUser.getId());
        userRole.setRoleId(RhoUserRolesEnum.RHO_COMPANY_SUPER_ADMIN.getRoleId());
        this.sysUserRoleMapper.insert(userRole);
    }

    @Override
    @Transactional(isolation=Isolation.SERIALIZABLE)
    public boolean addUserForCom(SysCompanyUserAddForComParam param) {
        if (!this.checkUsername(param.getUsername(), null)) {
            throw new ServiceException("\u7528\u6237\u540d\u5df2\u5b58\u5728\uff01");
        }
        SysUser sysUser = this.converter.sysCompanyUserAddForComParam2Entity(param);
        if (sysUser == null) {
            return false;
        }
        sysUser.setCid(param.getLoginCid());
        String salt = Digests.salt();
        sysUser.setResource(UserResourceEnum.MANUALLY_ADD.getValue());
        sysUser.setPassword(this.getPassword(DigestUtils.md5DigestAsHex((byte[])"Zyj@2022".getBytes()), salt));
        sysUser.setForbiddenUpdateTime(LocalDateTime.now());
        sysUser.setCreateBy(param.getLoginUserId());
        sysUser.setCreateDate(LocalDateTime.now());
        if (((SysUserMapper)this.baseMapper).insert(sysUser) > 0) {
            ArrayList<SysUserRole> addUserRoleList = new ArrayList<SysUserRole>(param.getRoleList().size());
            for (SysRoleDto role : param.getRoleList()) {
                SysUserRole userRole = new SysUserRole();
                userRole.setUserId(sysUser.getId());
                userRole.setRoleId(role.getRoleId());
                addUserRoleList.add(userRole);
            }
            return CollUtil.isNotEmpty((Collection)this.sysUserRoleMapper.insert(addUserRoleList));
        }
        return false;
    }

    @Override
    public boolean checkUsername(String username, Long userId) {
        SysUser record = this.getUserByUsername(username);
        return record == null || record.getId().equals(userId);
    }

    private String getPassword(String md5Password, String salt) {
        return CommonsUtils.encryptPassword((String)md5Password, (String)salt);
    }

    @Override
    @Transactional
    public void changePassword(Long userId, String oldPassword, String newPassword) {
        if (oldPassword.equals(newPassword)) {
            throw new ServiceException("\u65b0\u5bc6\u7801\u4e0d\u80fd\u548c\u65e7\u5bc6\u7801\u76f8\u540c\uff01");
        }
        SysUser sysUser = (SysUser)this.getById(userId);
        if (this.sysOperLogService.isPasswordAvailable(newPassword, sysUser.getUsername(), OperatorDataSourceEnum.RHO_COMPANY.getValue()).booleanValue()) {
            throw new ServiceException("\u4e0d\u53ef\u4f7f\u7528\u5386\u53f2\u5bc6\u7801\u6216\u521d\u59cb\u5bc6\u7801");
        }
        String saltPassword = this.getPassword(oldPassword, sysUser.getSalt());
        if (!sysUser.getPassword().equals(saltPassword)) {
            throw new ServiceException("\u65e7\u5bc6\u7801\u9519\u8bef\uff01");
        }
        String newSaltPassword = this.getPassword(newPassword, sysUser.getSalt());
        if (newSaltPassword.equals(sysUser.getPassword())) {
            throw new ServiceException("\u65b0\u5bc6\u7801\u4e0d\u80fd\u548c\u65e7\u5bc6\u7801\u76f8\u540c\uff01");
        }
        String salt = Digests.salt();
        sysUser.setPassword(this.getPassword(newPassword, salt));
        sysUser.setSalt(salt);
        sysUser.setChangePwDate(LocalDateTime.now());
        sysUser.setIsDefaultPwd(Integer.valueOf(0));
        this.updateById(sysUser);
        RedisUtils.deleteObject((String)("global:pwd_err_cnt:" + SpringEncryptUtils.decrypt((String)sysUser.getUsername())));
    }

    @Override
    @Transactional
    public void updatePassStateThreeMonth() {
        ((SysUserMapper)this.baseMapper).updatePassStateThreeMonth();
    }

    @Override
    @Transactional
    public void initHospitalAccountBatch() {
        List<BCompany> noAccountHospitalList = ((SysUserMapper)this.baseMapper).getNoAccountHospitalList();
        if (CollectionUtils.isEmpty(noAccountHospitalList)) {
            return;
        }
        log.info("\u65e0\u8d26\u53f7\u9662\u533a\u6761\u76ee\u6570\uff1a{}", (Object)noAccountHospitalList.size());
        noAccountHospitalList.forEach(item -> {
            if (!this.checkUsername(item.getName(), null)) {
                log.info("\u7528\u6237\u540d\u5df2\u5b58\u5728\uff1a{}\uff0c\u6570\u636eid\uff1a{}", (Object)item.getName(), (Object)item.getId());
                return;
            }
            SysUser sysUser = new SysUser();
            sysUser.setCid(item.getId());
            sysUser.setUsername(item.getName());
            sysUser.setNickname(item.getName());
            String salt = Digests.salt();
            sysUser.setResource(UserResourceEnum.SUPERVISE_ADD.getValue());
            sysUser.setPassword(CommonsUtils.encryptPassword((String)DigestUtils.md5DigestAsHex((byte[])"Zyj@2022".getBytes()), (String)salt));
            sysUser.setSalt(salt);
            sysUser.setCreateBy(Long.valueOf(1L));
            sysUser.setCreateDate(LocalDateTime.now());
            ((SysUserMapper)this.baseMapper).insert(sysUser);
            SysUserRole userRole = new SysUserRole();
            userRole.setUserId(sysUser.getId());
            userRole.setRoleId(RhoUserRolesEnum.RHO_COMPANY_SUPER_ADMIN.getRoleId());
            this.sysUserRoleMapper.insert(userRole);
        });
    }

    @Override
    @Transactional
    public void modifyPasswordByPhone(Long userId, String newPassword) {
        SysUser sysUser = this.getUserById(userId);
        if (!StringUtils.isValid((String)newPassword)) {
            throw new ServiceException("\u5bc6\u7801\u683c\u5f0f\u9519\u8bef");
        }
        if ("Zyj@2022".equals(newPassword)) {
            throw new ServiceException("\u65b0\u5bc6\u7801\u4e0d\u80fd\u548c\u521d\u59cb\u5bc6\u7801\u76f8\u540c\uff01");
        }
        String md5NewPassword = DigestUtils.md5DigestAsHex((byte[])newPassword.getBytes());
        String newSaltPassword = this.getPassword(md5NewPassword, sysUser.getSalt());
        if (newSaltPassword.equals(sysUser.getPassword())) {
            throw new ServiceException("\u65b0\u5bc6\u7801\u4e0d\u80fd\u548c\u65e7\u5bc6\u7801\u76f8\u540c\uff01");
        }
        if (this.sysOperLogService.isPasswordAvailable(md5NewPassword, sysUser.getUsername(), OperatorDataSourceEnum.RHO_COMPANY.getValue()).booleanValue()) {
            throw new ServiceException("\u4e0d\u53ef\u4f7f\u7528\u5386\u53f2\u5bc6\u7801\u6216\u521d\u59cb\u5bc6\u7801");
        }
        String salt = Digests.salt();
        sysUser.setPassword(this.getPassword(md5NewPassword, salt));
        sysUser.setSalt(salt);
        sysUser.setChangePwDate(LocalDateTime.now());
        sysUser.setIsDefaultPwd(Integer.valueOf(0));
        this.updateById(sysUser);
        RedisUtils.deleteObject((String)("global:pwd_err_cnt:" + SpringEncryptUtils.decrypt((String)sysUser.getUsername())));
    }

    @Generated
    public SysUserServiceImpl(SysUserConverter converter, SysUserRoleMapper sysUserRoleMapper, BCompanyMapper companyMapper) {
        this.converter = converter;
        this.sysUserRoleMapper = sysUserRoleMapper;
        this.companyMapper = companyMapper;
    }
}

