/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.sys.impl;

import cn.dev33.satoken.stp.StpUtil;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.PhoneUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.modules.datacentre.provider.sms.ISMSProviderWelinkService;
import cn.smarthse.modules.sys.enumd.UserSystemWideEnum;
import cn.smarthse.rho.core.framework.RedisKey;
import cn.smarthse.rho.core.framework.ShiroCommonUtil;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.core.framework.model.LayuiGridParam;
import cn.smarthse.rho.core.framework.utils.CommonsUtils;
import cn.smarthse.rho.core.framework.utils.StringUtils;
import cn.smarthse.rho.modules.sys.dao.sys.SysUserBindMapper;
import cn.smarthse.rho.modules.sys.entity.bind.ContactRebindAppeal;
import cn.smarthse.rho.modules.sys.entity.bind.SysUserBind;
import cn.smarthse.rho.modules.sys.entity.bind.SysUserBindLog;
import cn.smarthse.rho.modules.sys.entity.sys.SysUser;
import cn.smarthse.rho.modules.sys.enums.bind.ContactBindAuditStatusEnum;
import cn.smarthse.rho.modules.sys.enums.bind.UserBindLogTypeEnum;
import cn.smarthse.rho.modules.sys.model.bind.param.AbnormalContacDetailParam;
import cn.smarthse.rho.modules.sys.model.bind.param.AbnormalContacListParam;
import cn.smarthse.rho.modules.sys.model.bind.param.AbnormalContacToFocusParam;
import cn.smarthse.rho.modules.sys.model.bind.param.ContactUnbindParam;
import cn.smarthse.rho.modules.sys.model.bind.vo.AbnormalContactDetailVo;
import cn.smarthse.rho.modules.sys.model.bind.vo.AbnormalContactListVo;
import cn.smarthse.rho.modules.sys.model.bind.vo.SysUserBindCompanyVo;
import cn.smarthse.rho.modules.sys.model.sys.param.SysUserBindParam;
import cn.smarthse.rho.modules.sys.service.bind.IContactRebindAppealService;
import cn.smarthse.rho.modules.sys.service.sys.ISysFileService;
import cn.smarthse.rho.modules.sys.service.sys.ISysUserBindLogService;
import cn.smarthse.rho.modules.sys.service.sys.ISysUserBindService;
import cn.smarthse.rho.modules.sys.service.sys.ISysUserService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.jetbrains.annotations.NotNull;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysUserBindServiceImpl
extends ServiceImpl<SysUserBindMapper, SysUserBind>
implements ISysUserBindService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SysUserBindServiceImpl.class);
    @Autowired
    @Lazy
    private SysUserBindServiceImpl self;
    @Autowired
    @Lazy
    private IContactRebindAppealService contactRebindAppealService;
    @DubboReference(registry={"public_nacos"})
    private ISMSProviderWelinkService smsProvideMasService;
    private final ISysUserService sysUserService;
    private final RedissonClient redissonClient;
    private final ISysUserBindLogService userBindLogService;
    private final ISysFileService sysFileService;

    @Override
    public SysUserBind getByUserId(Long userId, Integer systemSource) {
        if (userId == null) {
            throw new ServiceException("\u7528\u6237id\u4e3a\u7a7a");
        }
        return ((SysUserBindMapper)this.baseMapper).getBindByUserId(userId, systemSource);
    }

    @Override
    @Transactional
    public void bindTel(SysUserBindParam param, Integer source) {
        Long userId = param.getUserId();
        if (userId == null) {
            throw new ServiceException("\u7ed1\u5b9a\u6216\u6362\u7ed1\u7684\u5bf9\u8c61\u4fe1\u606f\u4e3a\u7a7a");
        }
        String lockKey = RedisKey.getLockKey((String)userId.toString());
        RLock lock = this.redissonClient.getLock(lockKey);
        boolean locked = false;
        try {
            locked = lock.tryLock(3L, 10L, TimeUnit.SECONDS);
            if (!locked) {
                throw new ServiceException("\u5f53\u524d\u4f01\u4e1a\u6b63\u5728\u88ab\u5176\u4ed6\u4eba\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            SysUserBind userBind = this.self.getByUserId(userId, source);
            Integer count = ((SysUserBindMapper)this.baseMapper).getCountIsFocusByTel(SpringEncryptUtils.encrypt((String)param.getBindTel()));
            Byte isFocus = count != null && count > 0 ? (byte)1 : 0;
            boolean isNewBind = userBind == null;
            SysUser sysUser = this.sysUserService.getUserById(userId);
            if (isNewBind) {
                userBind = new SysUserBind();
                userBind.setCid(sysUser.getCid());
                userBind.setUserId(userId);
                userBind.setSystemSource(UserSystemWideEnum.RHO_COMPANY.getCode());
                userBind.setBindName(param.getBindName());
                userBind.setBindTel(param.getBindTel());
                userBind.setIsFocus(isFocus);
                this.self.save(userBind);
            } else {
                if (param.getBindTel().equals(userBind.getBindTel())) {
                    throw new ServiceException("\u6362\u7ed1\u624b\u673a\u53f7\u4e0e\u5f53\u524d\u7ed1\u5b9a\u624b\u673a\u53f7\u76f8\u540c");
                }
                userBind.setBindName(param.getBindName()).setBindTel(param.getBindTel()).setIsFocus(isFocus);
                SysUserBind copyUserBind = new SysUserBind();
                BeanUtil.copyProperties((Object)userBind, (Object)copyUserBind, (String[])new String[0]);
                this.self.updateById(copyUserBind);
            }
            userBind.setCid(sysUser.getCid());
            userBind.setUserId(userId);
            userBind.setSystemSource(source);
            userBind.setBindName(param.getBindName());
            userBind.setBindTel(param.getBindTel());
            if (param.getUserBindLogType() != null) {
                SysUserBindLog log = new SysUserBindLog();
                log.setBindName(userBind.getBindName());
                log.setBindTel(userBind.getBindTel());
                log.setSystemSource(userBind.getSystemSource());
                log.setCid(userBind.getCid());
                log.setUserId(userBind.getUserId());
                log.setType(param.getUserBindLogType());
                log.setAuditState(param.getAuditState());
                log.setIsValid(Integer.valueOf(1));
                log.setCreateBy(param.getAuditUserId());
                log.setUpdateBy(param.getAuditUserId());
                log.setEvidenceId(param.getEvidenceId());
                this.userBindLogService.addRBindAppleLog(log);
            } else {
                this.userBindLogService.addBindLog(userBind, isNewBind ? UserBindLogTypeEnum.BINDING.getValue() : UserBindLogTypeEnum.REBIND.getValue(), ContactBindAuditStatusEnum.NOT_NEED_AUDIT.getCode().byteValue(), userId);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ServiceException("\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        finally {
            if (locked) {
                lock.unlock();
            }
        }
    }

    @Override
    @Transactional
    public void sendRebindAppeal(SysUserBindParam param) {
        SysUserBind bindInfo = ((SysUserBindMapper)this.baseMapper).getBindByUserId(param.getUserId(), UserSystemWideEnum.RHO_COMPANY.getCode());
        if (bindInfo == null) {
            throw new ServiceException("\u5f53\u524d\u672a\u7ed1\u5b9a\u624b\u673a\u53f7,\u8bf7\u5148\u7ed1\u5b9a");
        }
        if (bindInfo.getBindTel().equals(param.getBindTel())) {
            throw new ServiceException("\u6362\u7ed1\u624b\u673a\u53f7\u4e0e\u5f53\u524d\u7ed1\u5b9a\u624b\u673a\u53f7\u76f8\u540c");
        }
        if (this.sysFileService.getById(param.getEvidenceId()) == null) {
            throw new ServiceException("\u4f50\u8bc1\u6750\u6599id\u65e0\u6548\uff0c\u8bf7\u4e0a\u4f20\u6709\u6548\u4f50\u8bc1\u6750\u6599");
        }
        if (this.contactRebindAppealService.selectUnAuditAppealByCid(param.getUserId()).booleanValue()) {
            throw new ServiceException("\u60a8\u6709\u6b63\u5728\u5ba1\u6838\u4e2d\u7684\u6362\u7ed1\u7533\u8bf7\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u5ba1\u6838");
        }
        ContactRebindAppeal contactRebindAppeal = new ContactRebindAppeal();
        contactRebindAppeal.setCid(bindInfo.getCid());
        contactRebindAppeal.setUserId(bindInfo.getUserId());
        contactRebindAppeal.setCurrentContactName(bindInfo.getBindName());
        contactRebindAppeal.setCurrentContactPhone(bindInfo.getBindTel());
        contactRebindAppeal.setSystemWide(UserSystemWideEnum.RHO_COMPANY.getCode());
        contactRebindAppeal.setNewContactPhone(param.getBindTel());
        contactRebindAppeal.setNewContactName(param.getBindName());
        contactRebindAppeal.setEvidenceId(param.getEvidenceId());
        contactRebindAppeal.setAuditStatus(ContactBindAuditStatusEnum.AUDIT.getCode());
        this.contactRebindAppealService.addAppeal(contactRebindAppeal);
        SysUserBindLog sysUserBindLog = new SysUserBindLog();
        sysUserBindLog.setUserId(bindInfo.getUserId());
        sysUserBindLog.setCid(bindInfo.getCid());
        sysUserBindLog.setBindTel(param.getBindTel());
        sysUserBindLog.setBindName(param.getBindName());
        sysUserBindLog.setSystemSource(UserSystemWideEnum.RHO_COMPANY.getCode());
        sysUserBindLog.setEvidenceId(param.getEvidenceId());
        sysUserBindLog.setType(UserBindLogTypeEnum.APPEAL.getValue());
        sysUserBindLog.setAuditState(Byte.valueOf(ContactBindAuditStatusEnum.AUDIT.getCode().byteValue()));
        this.userBindLogService.addRBindAppleLog(sysUserBindLog);
    }

    @Override
    @Transactional
    public Boolean unbindUser(ContactUnbindParam param) {
        SysUserBind bindInfo = this.getByUserId(param.getUserId(), UserSystemWideEnum.RHO_COMPANY.getCode());
        if (bindInfo == null) {
            throw new ServiceException("\u8be5\u7528\u6237\u672a\u7ed1\u5b9a\u624b\u673a\u53f7\uff0c\u65e0\u9700\u89e3\u7ed1");
        }
        int count = ((SysUserBindMapper)this.baseMapper).deleteById(bindInfo.getId());
        this.userBindLogService.addBindLog(bindInfo, UserBindLogTypeEnum.UNBIND.getValue(), ContactBindAuditStatusEnum.UNBIND.getCode().byteValue(), param.getCurrentUserId());
        StpUtil.logout((Object)ShiroCommonUtil.getLoginId((String)"company", (Long)bindInfo.getUserId()));
        this.smsProvideMasService.singleSendSms(bindInfo.getBindTel(), "\u3010\u6d59\u6c5f\u7701\u75be\u63a7\u5c40\u3011\u60a8\u7684\u624b\u673a\u53f7\u5df2\u4e0e\u201c\u653e\u5c04\u536b\u751f\u5728\u7ebf\u201d\u8d26\u53f7\u89e3\u7ed1\u6210\u529f\uff0c\u8bf7\u5c3d\u5feb\u81f3\u201c\u653e\u5c04\u536b\u751f\u5728\u7ebf\u201d\u7ed1\u5b9a\u65b0\u7684\u624b\u673a\u53f7\u3002");
        log.info("\u624b\u673a\u89e3\u7ed1\u6210\u529f\uff0c\u89e3\u7ed1\u624b\u673a\u53f7{}", (Object)bindInfo.getBindTel());
        return count > 0;
    }

    @Override
    public LayuiGridData<AbnormalContactListVo> getAbnormalContactListData(AbnormalContacListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        if (StringUtils.isNotEmpty((String)param.getKeyword())) {
            param.setKeywordEn(param.getKeyword());
        }
        List<AbnormalContactListVo> list = ((SysUserBindMapper)this.baseMapper).getAbnormalContactListData(param);
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    public Boolean toFocusPhone(AbnormalContacToFocusParam param) {
        int count = ((SysUserBindMapper)this.baseMapper).toFocusPhone(param);
        return count > 0;
    }

    @Override
    public AbnormalContactDetailVo getAbnormalContactDetail(AbnormalContacDetailParam param) {
        AbnormalContactDetailVo vo = new AbnormalContactDetailVo();
        List<SysUserBindCompanyVo> list = ((SysUserBindMapper)this.baseMapper).getBindListByBindTel(param);
        if (CollectionUtil.isEmpty(list)) {
            return vo;
        }
        vo.setList(list);
        vo.setBindTel(list.get(0).getBindTel());
        vo.setBindCount(Integer.valueOf(list.size()));
        vo.setIsFocus(list.get(0).getIsFocus());
        return vo;
    }

    @Override
    public SysUserBind getByUserNameOrCid(String username, Long cid, Integer accountType) {
        SysUser sysUser;
        if (accountType == 1) {
            if (username == null) {
                throw new ServiceException("username\u4e0d\u80fd\u4e3anull");
            }
            sysUser = this.sysUserService.getUserByUsername(username);
        } else {
            if (cid == null) {
                throw new ServiceException("cid\u4e0d\u80fd\u4e3anull");
            }
            sysUser = this.sysUserService.getManagerUserByCid(cid);
        }
        if (sysUser == null) {
            throw new ServiceException("\u672a\u627e\u5230\u5bf9\u5e94\u8d26\u53f7\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        return this.getByUserId(sysUser.getId(), UserSystemWideEnum.RHO_COMPANY.getCode());
    }

    @Override
    public void bind(Long userId, String bindName, String bindTel) {
        if (!PhoneUtil.isMobile((CharSequence)bindTel)) {
            throw new ServiceException("\u653e\u5c04\u8bca\u7597\u673a\u6784\u8054\u7cfb\u4eba\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef");
        }
        if (!CommonsUtils.isValidBindName((String)bindName)) {
            throw new ServiceException("\u653e\u5c04\u8bca\u7597\u673a\u6784\u8054\u7cfb\u4eba\u59d3\u540d\u683c\u5f0f\uff1a\u4e2d\u6587\u6216\u82f1\u6587\uff0c\u4e0d\u5141\u8bb8\u6570\u5b57\u3001\u7279\u6b8a\u7b26\u53f7\u3001\u4e2d\u95f4\u7a7a\u683c");
        }
        SysUserBindParam param = new SysUserBindParam();
        param.setUserId(userId);
        param.setBindName(bindName);
        param.setBindTel(bindTel);
        param.setSystemWideCode(UserSystemWideEnum.RHO_COMPANY.getCode());
        param.setOperatorId(userId);
        this.bindOrRebind(param);
    }

    @Override
    @Transactional
    public void bindOrRebind(SysUserBindParam param) {
        boolean isNewBind;
        Long userId = param.getUserId();
        String bindName = param.getBindName();
        String bindTel = param.getBindTel();
        Integer systemWideCode = param.getSystemWideCode();
        Integer userBindLogType = param.getUserBindLogType();
        Byte auditState = param.getAuditState();
        Long operatorId = param.getOperatorId();
        Long evidenceId = param.getEvidenceId();
        SysUserBind userBind = this.getByUserId(userId, systemWideCode);
        boolean bl = isNewBind = userBind == null;
        if (userBindLogType == null) {
            Integer n = userBindLogType = isNewBind ? UserBindLogTypeEnum.BINDING.getValue() : UserBindLogTypeEnum.REBIND.getValue();
        }
        if (auditState == null) {
            auditState = ContactBindAuditStatusEnum.NOT_NEED_AUDIT.getCode().byteValue();
        }
        RLock lock = this.redissonClient.getLock("global:user:bind:" + userId);
        boolean locked = false;
        try {
            locked = lock.tryLock(3L, 10L, TimeUnit.SECONDS);
            if (!locked) {
                throw new ServiceException("\u5f53\u524d\u4f01\u4e1a\u7ed1\u5b9a\u4fe1\u606f\u6b63\u5728\u88ab\u5176\u4ed6\u4eba\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            if (isNewBind) {
                this.addNewBind(userId, bindName, bindTel, systemWideCode, userBindLogType, auditState, operatorId, evidenceId);
            } else {
                this.updateBind(userBind, bindName, bindTel, userBindLogType, auditState, operatorId, evidenceId);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ServiceException("\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        finally {
            if (locked) {
                lock.unlock();
            }
        }
    }

    private void updateBind(SysUserBind userBind, String bindName, String bindTel, Integer userBindLogType, Byte auditState, Long operatorId, Long evidenceId) {
        if (!userBindLogType.equals(UserBindLogTypeEnum.APPEAL_PASS.getValue()) && bindTel.equals(userBind.getBindTel())) {
            throw new ServiceException("\u6362\u7ed1\u624b\u673a\u53f7\u4e0e\u5f53\u524d\u7ed1\u5b9a\u624b\u673a\u53f7\u76f8\u540c");
        }
        SysUserBind upParam = new SysUserBind();
        upParam.setId(userBind.getId());
        upParam.setBindName(bindName);
        upParam.setBindTel(bindTel);
        this.updateById(upParam);
        SysUserBindLog log = new SysUserBindLog();
        log.setBindName(bindName);
        log.setBindTel(bindTel);
        log.setSystemSource(userBind.getSystemSource());
        log.setCid(userBind.getCid());
        log.setUserId(userBind.getUserId());
        log.setType(userBindLogType);
        log.setAuditState(auditState);
        log.setCreateBy(operatorId);
        log.setUpdateBy(operatorId);
        log.setEvidenceId(evidenceId);
        this.userBindLogService.addRBindAppleLog(log);
    }

    private void addNewBind(Long userId, String bindName, String bindTel, Integer systemWideCode, Integer userBindLogType, Byte auditState, Long operatorId, Long evidenceId) {
        if (userId == null || StrUtil.isBlank((CharSequence)bindName) || StrUtil.isBlank((CharSequence)bindTel) || systemWideCode == null || userBindLogType == null || auditState == null || operatorId == null) {
            throw new ServiceException("\u53c2\u6570\u7f3a\u5931");
        }
        SysUserBind userBind = new SysUserBind();
        userBind.setCid(this.sysUserService.getUserById(userId).getCid());
        userBind.setUserId(userId);
        userBind.setSystemSource(systemWideCode);
        userBind.setBindName(bindName);
        userBind.setBindTel(bindTel);
        userBind.setIsFocus(this.getBindTelIsFocus(bindTel));
        this.self.save(userBind);
        SysUserBindLog log = new SysUserBindLog();
        log.setBindName(bindName);
        log.setBindTel(bindTel);
        log.setSystemSource(userBind.getSystemSource());
        log.setCid(userBind.getCid());
        log.setUserId(userId);
        log.setType(userBindLogType);
        log.setAuditState(auditState);
        log.setCreateBy(operatorId);
        log.setUpdateBy(operatorId);
        log.setEvidenceId(evidenceId);
        this.userBindLogService.addRBindAppleLog(log);
    }

    @NotNull
    private Byte getBindTelIsFocus(String bindTel) {
        Integer count = ((SysUserBindMapper)this.baseMapper).getCountIsFocusByTel(SpringEncryptUtils.encrypt((String)bindTel));
        Byte isFocus = count != null && count > 0 ? (byte)1 : 0;
        return isFocus;
    }

    @Override
    public void bindApplication(Long loginUserId, String bindName, String bindTel, Long fileId) {
        if (ObjectUtil.isNull((Object)loginUserId)) {
            throw new ServiceException("\u767b\u5f55\u7528\u6237Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)bindName)) {
            throw new ServiceException("\u653e\u5c04\u8bca\u7597\u673a\u6784\u8054\u7cfb\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)bindTel)) {
            throw new ServiceException("\u653e\u5c04\u8bca\u7597\u673a\u6784\u8054\u7cfb\u4eba\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNull((Object)fileId)) {
            throw new ServiceException("\u4f50\u8bc1\u6750\u6599Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!CommonsUtils.isValidBindName((String)bindName)) {
            throw new ServiceException("\u653e\u5c04\u8bca\u7597\u673a\u6784\u8054\u7cfb\u4eba\u59d3\u540d\u683c\u5f0f\uff1a\u4e2d\u6587\u6216\u82f1\u6587\uff0c\u4e0d\u5141\u8bb8\u6570\u5b57\u3001\u7279\u6b8a\u7b26\u53f7\u3001\u4e2d\u95f4\u7a7a\u683c");
        }
        SysUserBind currentBind = this.getByUserId(loginUserId, UserSystemWideEnum.RHO_COMPANY.getCode());
        if (currentBind == null) {
            throw new ServiceException("\u5f53\u524d\u7528\u6237\u672a\u7ed1\u5b9a\u624b\u673a\u53f7,\u8bf7\u5148\u7ed1\u5b9a");
        }
        if (this.sysFileService.getById(fileId) == null) {
            throw new ServiceException("\u4f50\u8bc1\u6750\u6599id\u65e0\u6548\uff0c\u8bf7\u4e0a\u4f20\u6709\u6548\u4f50\u8bc1\u6750\u6599");
        }
        if (this.contactRebindAppealService.selectUnAuditAppealByCid(loginUserId).booleanValue()) {
            throw new ServiceException("\u60a8\u6709\u6b63\u5728\u5ba1\u6838\u4e2d\u7684\u6362\u7ed1\u7533\u8bf7\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u5ba1\u6838");
        }
        ContactRebindAppeal appeal = new ContactRebindAppeal();
        appeal.setCid(currentBind.getCid());
        appeal.setUserId(loginUserId);
        appeal.setCurrentContactName(currentBind.getBindName());
        appeal.setCurrentContactPhone(currentBind.getBindTel());
        appeal.setSystemWide(UserSystemWideEnum.RHO_COMPANY.getCode());
        appeal.setNewContactName(bindName);
        appeal.setNewContactPhone(bindTel);
        appeal.setEvidenceId(fileId);
        appeal.setAuditStatus(ContactBindAuditStatusEnum.AUDIT.getCode());
        this.contactRebindAppealService.addAppeal(appeal);
        SysUserBindLog log = new SysUserBindLog();
        log.setUserId(currentBind.getUserId());
        log.setCid(currentBind.getCid());
        log.setBindTel(bindTel);
        log.setBindName(bindName);
        log.setSystemSource(UserSystemWideEnum.RHO_COMPANY.getCode());
        log.setEvidenceId(fileId);
        log.setType(UserBindLogTypeEnum.APPEAL.getValue());
        log.setAuditState(Byte.valueOf(ContactBindAuditStatusEnum.AUDIT.getCode().byteValue()));
        log.setCreateBy(loginUserId);
        log.setUpdateBy(loginUserId);
        this.userBindLogService.addRBindAppleLog(log);
    }

    @Generated
    public SysUserBindServiceImpl(ISysUserService sysUserService, RedissonClient redissonClient, ISysUserBindLogService userBindLogService, ISysFileService sysFileService) {
        this.sysUserService = sysUserService;
        this.redissonClient = redissonClient;
        this.userBindLogService = userBindLogService;
        this.sysFileService = sysFileService;
    }
}

