/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.sys.impl;

import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.core.framework.model.LayuiGridParam;
import cn.smarthse.rho.modules.sys.dao.sys.SysUserBindLogMapper;
import cn.smarthse.rho.modules.sys.entity.bind.SysUserBind;
import cn.smarthse.rho.modules.sys.entity.bind.SysUserBindLog;
import cn.smarthse.rho.modules.sys.enums.bind.ContactBindAuditStatusEnum;
import cn.smarthse.rho.modules.sys.enums.bind.UserBindLogTypeEnum;
import cn.smarthse.rho.modules.sys.model.bind.param.ContactRebindHistoryParam;
import cn.smarthse.rho.modules.sys.model.bind.param.ContactRebindRecordParam;
import cn.smarthse.rho.modules.sys.model.bind.vo.ContactRebindAppealRecordVo;
import cn.smarthse.rho.modules.sys.model.bind.vo.ContactRebindHistoryVo;
import cn.smarthse.rho.modules.sys.model.bind.vo.SysUserBindLogVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysFileVo;
import cn.smarthse.rho.modules.sys.service.sys.ISysFileService;
import cn.smarthse.rho.modules.sys.service.sys.ISysUserBindLogService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SysUserBindLogServiceImpl
extends ServiceImpl<SysUserBindLogMapper, SysUserBindLog>
implements ISysUserBindLogService {
    private final ISysFileService sysFileService;

    @Override
    public void addBindLog(SysUserBind userBind, Integer logType, Byte auditState, Long createBy) {
        SysUserBindLog log = new SysUserBindLog();
        log.setBindName(userBind.getBindName());
        log.setBindTel(userBind.getBindTel());
        log.setSystemSource(userBind.getSystemSource());
        log.setCid(userBind.getCid());
        log.setUserId(userBind.getUserId());
        log.setType(logType);
        log.setAuditState(auditState);
        log.setIsValid(Integer.valueOf(1));
        log.setCreateBy(createBy);
        log.setUpdateBy(createBy);
        this.save(log);
    }

    @Override
    public void addRBindAppleLog(SysUserBindLog sysUserBindLog) {
        ((SysUserBindLogMapper)this.baseMapper).insert(sysUserBindLog);
    }

    @Override
    public LayuiGridData<ContactRebindAppealRecordVo> getRebindAppealRecord(ContactRebindRecordParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<ContactRebindAppealRecordVo> list = ((SysUserBindLogMapper)this.baseMapper).getRebindAppealRecord(param);
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    public LayuiGridData<ContactRebindHistoryVo> getRebindHistory(ContactRebindHistoryParam param) {
        Map<Object, Object> fileVoMap;
        List<SysUserBindLogVo> logList = ((SysUserBindLogMapper)this.baseMapper).selectLogVoByUserId(param.getUserId());
        ArrayList voList = new ArrayList(logList.size());
        Set idSet = logList.stream().map(SysUserBindLogVo::getEvidenceId).filter(Objects::nonNull).collect(Collectors.toSet());
        if (!idSet.isEmpty()) {
            String idStr = idSet.stream().map(String::valueOf).collect(Collectors.joining(","));
            fileVoMap = this.sysFileService.getFileVoByIds(idStr).stream().collect(Collectors.toMap(SysFileVo::getId, Function.identity(), (a, b) -> b));
        } else {
            fileVoMap = Map.of();
        }
        logList.stream().forEach(log -> {
            ContactRebindHistoryVo vo = new ContactRebindHistoryVo();
            vo.setId(log.getId());
            vo.setOperatorName(log.getCreateUserName());
            vo.setOperatorTime(log.getCreateDate());
            vo.setOperatorType(UserBindLogTypeEnum.getName((Integer)log.getType()));
            vo.setBindName(log.getBindName());
            vo.setBindTel(log.getBindTel());
            if (log.getEvidenceId() != null) {
                vo.setEvidenceFileName(((SysFileVo)fileVoMap.get(log.getEvidenceId())).getFileName());
                vo.setEvidenceFileUrl(((SysFileVo)fileVoMap.get(log.getEvidenceId())).getFullOssUrl());
            }
            vo.setAuditResult(ContactBindAuditStatusEnum.getName((Integer)log.getAuditState().intValue()));
            voList.add(vo);
        });
        return new LayuiGridData(voList, Integer.valueOf(param.getPage()), Integer.valueOf(param.getLimit()));
    }

    @Generated
    public SysUserBindLogServiceImpl(ISysFileService sysFileService) {
        this.sysFileService = sysFileService;
    }
}

