/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.sys.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.core.utils.SpringUtils;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.framework.oss.bean.OssClientBean;
import cn.smarthse.rho.core.framework.Constant;
import cn.smarthse.rho.core.framework.model.BaseEntity;
import cn.smarthse.rho.core.framework.utils.StringUtils;
import cn.smarthse.rho.modules.sys.converter.sys.SysConverter;
import cn.smarthse.rho.modules.sys.dao.sys.SysFileMapper;
import cn.smarthse.rho.modules.sys.entity.sys.SysFile;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysFileVo;
import cn.smarthse.rho.modules.sys.service.sys.ISysFileService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SysFileServiceImpl
extends ServiceImpl<SysFileMapper, SysFile>
implements ISysFileService {
    private final OssClientBean ossClientBean;
    private final SysConverter converter;

    @Cacheable(value={"file=24"}, key="#id", unless="#result == null", condition="#id != null")
    public SysFile getById(Serializable id) {
        return (SysFile)super.getById(id);
    }

    @Override
    public SysFile getByHash(String filehash) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysFile::getFileHash, (Object)filehash)).eq(BaseEntity::getIsValid, (Object)Constant.ACTIVE_YES)).last("limit 1");
        return (SysFile)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @Cacheable(value={"files=24"}, key="#ids")
    public List<SysFile> getFileById(String ids) {
        if (StrUtil.isBlank((CharSequence)ids)) {
            return null;
        }
        List idList = Arrays.stream(ids.split(",")).map(Long::parseLong).collect(Collectors.toList());
        return this.listByIds(idList);
    }

    @Override
    public String getUrl(Long id) {
        SysFile sysFile = this.getById(id);
        return sysFile == null ? null : this.ossClientBean.getUrl(sysFile.getOssUrl());
    }

    @Override
    public List<SysFileVo> getFileVoByIds(String files) {
        if (StringUtils.isEmpty((CharSequence)files)) {
            return null;
        }
        List<SysFile> list = ((SysFileServiceImpl)SpringUtils.getBean(this.getClass())).getFileById(files);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        list.forEach(record -> record.setFullOssUrl(this.ossClientBean.getUrl(record.getOssUrl())));
        return this.converter.sysFile2SysFileVo(list);
    }

    @Override
    public SysFile getTrainingFileBySourceId(Long sourceFileId) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)wrapper.lambda().eq(SysFile::getSourceId, (Object)sourceFileId)).eq(BaseEntity::getIsValid, (Object)Constant.ACTIVE_YES);
        List list = this.list((Wrapper)wrapper);
        return CollUtil.isEmpty((Collection)list) ? null : (SysFile)list.get(0);
    }

    @Generated
    public SysFileServiceImpl(OssClientBean ossClientBean, SysConverter converter) {
        this.ossClientBean = ossClientBean;
        this.converter = converter;
    }
}

