/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.risk.impl;

import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.rho.modules.sys.converter.RRiskBasicConverter;
import cn.smarthse.rho.modules.sys.dao.risk.RiskBasicSourceHistoryCommonMapper;
import cn.smarthse.rho.modules.sys.entity.r.RRiskBasicSource;
import cn.smarthse.rho.modules.sys.entity.r.RRiskBasicSourceHistory;
import cn.smarthse.rho.modules.sys.service.risk.IRiskBasicSourceHistoryCommonService;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class RiskBasicSourceHistoryCommonServiceImpl
extends ServiceImpl<RiskBasicSourceHistoryCommonMapper, RRiskBasicSourceHistory>
implements IRiskBasicSourceHistoryCommonService {
    @Autowired
    private RRiskBasicConverter converter;

    @Override
    @Transactional
    public void saveSourceAsHistory(List<RRiskBasicSource> sourceList, String changeReason) {
        List<RRiskBasicSourceHistory> historyList = this.converter.sourceList2HistoryList(sourceList);
        historyList.stream().forEach(history -> {
            history.setSourceId(history.getId());
            history.setId(Long.valueOf(IdWorker.getId()));
            history.setChangeReason(changeReason);
            history.setChangeDate(LocalDateTime.now());
            history.setCreateDate(LocalDateTime.now());
            history.setUpdateDate(LocalDateTime.now());
        });
        this.saveBatch(historyList);
    }
}

