/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.risk.impl;

import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.rho.core.framework.model.BaseEntity;
import cn.smarthse.rho.modules.sys.dao.risk.RiskBasicSourceCommonMapper;
import cn.smarthse.rho.modules.sys.entity.r.RRiskBasicSource;
import cn.smarthse.rho.modules.sys.enums.risk.RiskPostStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskWarningStatusEnum;
import cn.smarthse.rho.modules.sys.model.r.param.RiskManagerDefuseParam;
import cn.smarthse.rho.modules.sys.model.r.param.SearchRiskParam;
import cn.smarthse.rho.modules.sys.service.risk.IRiskBasicSourceCommonService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(readOnly=true)
public class RiskBasicSourceCommonServiceImpl
extends ServiceImpl<RiskBasicSourceCommonMapper, RRiskBasicSource>
implements IRiskBasicSourceCommonService {
    @Override
    public List<RRiskBasicSource> listSourceByBasicId(Long basicId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(RRiskBasicSource::getRiskId, (Object)basicId)).eq(BaseEntity::getIsValid, (Object)1);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RRiskBasicSource> getCmCertRiskForManager(RiskManagerDefuseParam param) {
        return ((RiskBasicSourceCommonMapper)this.baseMapper).getCmCertRiskForManager(param);
    }

    @Override
    public List<RRiskBasicSource> getHealthCheckRiskForManager(RiskManagerDefuseParam param) {
        return ((RiskBasicSourceCommonMapper)this.baseMapper).getHealthCheckRiskForManager(param);
    }

    @Override
    public List<RRiskBasicSource> getTrainingRiskForManager(RiskManagerDefuseParam param) {
        return ((RiskBasicSourceCommonMapper)this.baseMapper).getTrainingRiskForManager(param);
    }

    @Override
    public List<Long> getTrainingRiskIdListForDefuse(RiskManagerDefuseParam param) {
        return ((RiskBasicSourceCommonMapper)this.baseMapper).getTrainingRiskIdListForDefuse(param);
    }

    @Override
    public List<RRiskBasicSource> getDoseRiskForManager(RiskManagerDefuseParam param) {
        return ((RiskBasicSourceCommonMapper)this.baseMapper).getDoseRiskForManager(param);
    }

    @Override
    public RRiskBasicSource getTrainingRiskForDuplicateCheck(Long staffBaseInfoId, Integer year) {
        return ((RiskBasicSourceCommonMapper)this.baseMapper).getTrainingRiskForDuplicateCheck(staffBaseInfoId, year, RiskTypeEnum.TRAINING.getValue());
    }

    @Override
    public List<Long> listPerformanceTestSourceIdForManager(RiskManagerDefuseParam param) {
        ArrayList<Long> rst = new ArrayList<Long>();
        rst.addAll(((RiskBasicSourceCommonMapper)this.baseMapper).listPerformanceTestSourceIdForManager(param));
        rst.addAll(((RiskBasicSourceCommonMapper)this.baseMapper).listProTestSourceIdWithNoDataForManager(param));
        return rst;
    }

    @Override
    public List<Long> listPlaceTestSourceIdForManager(RiskManagerDefuseParam param) {
        ArrayList<Long> rst = new ArrayList<Long>();
        rst.addAll(((RiskBasicSourceCommonMapper)this.baseMapper).listPlaceTestSourceIdForManager(param));
        rst.addAll(((RiskBasicSourceCommonMapper)this.baseMapper).listPlaceTestSourceIdWithNoDataForManager(param));
        return rst;
    }

    @Override
    public List<RRiskBasicSource> listWarningSource(Integer riskType, Integer warningType) {
        return ((RiskBasicSourceCommonMapper)this.baseMapper).listWarningSource(LocalDate.now().getYear(), riskType, warningType);
    }

    @Override
    public List<RRiskBasicSource> listWarningSourceForNoneWarningStatus(Integer riskType, Integer afterWarningStatus) {
        return ((RiskBasicSourceCommonMapper)this.baseMapper).listWarningSourceForNoneWarningStatus(LocalDate.now().getYear(), riskType, afterWarningStatus);
    }

    @Override
    @Transactional
    public void maintenanceWarningSourceForNone() {
        int year = LocalDate.now().getYear();
        ArrayList<RRiskBasicSource> firstList = new ArrayList<RRiskBasicSource>();
        List<RRiskBasicSource> performanceFirstWarningListForNone = ((RiskBasicSourceCommonMapper)this.baseMapper).listWarningSourceForMaintenance(year, RiskTypeEnum.PERFORMANCE_TEST.getValue(), RiskWarningStatusEnum.FIRST.getValue());
        List<RRiskBasicSource> placeFirstWarningListForNone = ((RiskBasicSourceCommonMapper)this.baseMapper).listWarningSourceForMaintenance(year, RiskTypeEnum.PLACE_TEST.getValue(), RiskWarningStatusEnum.FIRST.getValue());
        List<RRiskBasicSource> phyExamWarningListForNone = ((RiskBasicSourceCommonMapper)this.baseMapper).listWarningSourceForMaintenance(year, RiskTypeEnum.PHYSICAL_EXAMINATION.getValue(), RiskWarningStatusEnum.FIRST.getValue());
        List<RRiskBasicSource> trainWarningListForNone = ((RiskBasicSourceCommonMapper)this.baseMapper).listWarningSourceForMaintenance(year, RiskTypeEnum.TRAINING.getValue(), RiskWarningStatusEnum.FIRST.getValue());
        List<RRiskBasicSource> personalWarningListForNone = ((RiskBasicSourceCommonMapper)this.baseMapper).listWarningSourceForMaintenance(year, RiskTypeEnum.PERSONAL_PROTECTIVE_EQUIPMENT.getValue(), RiskWarningStatusEnum.FIRST.getValue());
        List<RRiskBasicSource> safetyWarningListForNone = ((RiskBasicSourceCommonMapper)this.baseMapper).listWarningSourceForMaintenance(year, RiskTypeEnum.SAFETY_DEVICES_AND_ALERTS.getValue(), RiskWarningStatusEnum.FIRST.getValue());
        firstList.addAll(performanceFirstWarningListForNone);
        firstList.addAll(placeFirstWarningListForNone);
        firstList.addAll(phyExamWarningListForNone);
        firstList.addAll(trainWarningListForNone);
        firstList.addAll(personalWarningListForNone);
        firstList.addAll(safetyWarningListForNone);
        if (!CollectionUtils.isEmpty(firstList)) {
            firstList.stream().forEach(source -> source.setWarningStatus(RiskWarningStatusEnum.FIRST.getValue()));
            this.updateBatchById(firstList);
            firstList = null;
        }
        ArrayList<RRiskBasicSource> yellowList = new ArrayList<RRiskBasicSource>();
        List<RRiskBasicSource> performanceYellowWarningListForNone = ((RiskBasicSourceCommonMapper)this.baseMapper).listWarningSourceForMaintenance(year, RiskTypeEnum.PERFORMANCE_TEST.getValue(), RiskWarningStatusEnum.YELLOW.getValue());
        List<RRiskBasicSource> placeYellowWarningListForNone = ((RiskBasicSourceCommonMapper)this.baseMapper).listWarningSourceForMaintenance(year, RiskTypeEnum.PLACE_TEST.getValue(), RiskWarningStatusEnum.YELLOW.getValue());
        List<RRiskBasicSource> phyExamYellowWarningListForNone = ((RiskBasicSourceCommonMapper)this.baseMapper).listWarningSourceForMaintenance(year, RiskTypeEnum.PHYSICAL_EXAMINATION.getValue(), RiskWarningStatusEnum.YELLOW.getValue());
        List<RRiskBasicSource> trainYellowWarningListForNone = ((RiskBasicSourceCommonMapper)this.baseMapper).listWarningSourceForMaintenance(year, RiskTypeEnum.TRAINING.getValue(), RiskWarningStatusEnum.YELLOW.getValue());
        List<RRiskBasicSource> personalYellowWarningListForNone = ((RiskBasicSourceCommonMapper)this.baseMapper).listWarningSourceForMaintenance(year, RiskTypeEnum.PERSONAL_PROTECTIVE_EQUIPMENT.getValue(), RiskWarningStatusEnum.YELLOW.getValue());
        List<RRiskBasicSource> safetyYellowWarningListForNone = ((RiskBasicSourceCommonMapper)this.baseMapper).listWarningSourceForMaintenance(year, RiskTypeEnum.SAFETY_DEVICES_AND_ALERTS.getValue(), RiskWarningStatusEnum.YELLOW.getValue());
        yellowList.addAll(performanceYellowWarningListForNone);
        yellowList.addAll(placeYellowWarningListForNone);
        yellowList.addAll(phyExamYellowWarningListForNone);
        yellowList.addAll(trainYellowWarningListForNone);
        yellowList.addAll(personalYellowWarningListForNone);
        yellowList.addAll(safetyYellowWarningListForNone);
        if (!CollectionUtils.isEmpty(yellowList)) {
            yellowList.stream().forEach(source -> source.setWarningStatus(RiskWarningStatusEnum.YELLOW.getValue()));
            this.updateBatchById(yellowList);
            yellowList = null;
        }
        ArrayList<RRiskBasicSource> redList = new ArrayList<RRiskBasicSource>();
        List<RRiskBasicSource> performanceRedWarningListForNone = ((RiskBasicSourceCommonMapper)this.baseMapper).listWarningSourceForMaintenance(year, RiskTypeEnum.PERFORMANCE_TEST.getValue(), RiskWarningStatusEnum.RED.getValue());
        List<RRiskBasicSource> placeRedWarningListForNone = ((RiskBasicSourceCommonMapper)this.baseMapper).listWarningSourceForMaintenance(year, RiskTypeEnum.PLACE_TEST.getValue(), RiskWarningStatusEnum.RED.getValue());
        List<RRiskBasicSource> phyExamRedWarningListForNone = ((RiskBasicSourceCommonMapper)this.baseMapper).listWarningSourceForMaintenance(year, RiskTypeEnum.PHYSICAL_EXAMINATION.getValue(), RiskWarningStatusEnum.RED.getValue());
        List<RRiskBasicSource> trainRedWarningListForNone = ((RiskBasicSourceCommonMapper)this.baseMapper).listWarningSourceForMaintenance(year, RiskTypeEnum.TRAINING.getValue(), RiskWarningStatusEnum.RED.getValue());
        List<RRiskBasicSource> personalRedWarningListForNone = ((RiskBasicSourceCommonMapper)this.baseMapper).listWarningSourceForMaintenance(year, RiskTypeEnum.PERSONAL_PROTECTIVE_EQUIPMENT.getValue(), RiskWarningStatusEnum.RED.getValue());
        List<RRiskBasicSource> safetyRedWarningListForNone = ((RiskBasicSourceCommonMapper)this.baseMapper).listWarningSourceForMaintenance(year, RiskTypeEnum.SAFETY_DEVICES_AND_ALERTS.getValue(), RiskWarningStatusEnum.RED.getValue());
        redList.addAll(performanceRedWarningListForNone);
        redList.addAll(placeRedWarningListForNone);
        redList.addAll(phyExamRedWarningListForNone);
        redList.addAll(trainRedWarningListForNone);
        redList.addAll(personalRedWarningListForNone);
        redList.addAll(safetyRedWarningListForNone);
        if (!CollectionUtils.isEmpty(redList)) {
            redList.stream().forEach(source -> source.setWarningStatus(RiskWarningStatusEnum.RED.getValue()));
            this.updateBatchById(redList);
            redList = null;
        }
        ArrayList<RRiskBasicSource> activateLawList = new ArrayList<RRiskBasicSource>();
        List<RRiskBasicSource> performanceActivateListForNone = ((RiskBasicSourceCommonMapper)this.baseMapper).listWarningSourceForMaintenance(year, RiskTypeEnum.PERFORMANCE_TEST.getValue(), RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        List<RRiskBasicSource> placeActivateListForNone = ((RiskBasicSourceCommonMapper)this.baseMapper).listWarningSourceForMaintenance(year, RiskTypeEnum.PLACE_TEST.getValue(), RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        List<RRiskBasicSource> phyExamActivateListForNone = ((RiskBasicSourceCommonMapper)this.baseMapper).listWarningSourceForMaintenance(year, RiskTypeEnum.PHYSICAL_EXAMINATION.getValue(), RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        List<RRiskBasicSource> trainActivateListForNone = ((RiskBasicSourceCommonMapper)this.baseMapper).listWarningSourceForMaintenance(year, RiskTypeEnum.TRAINING.getValue(), RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        List<RRiskBasicSource> personalActivateListForNone = ((RiskBasicSourceCommonMapper)this.baseMapper).listWarningSourceForMaintenance(year, RiskTypeEnum.PERSONAL_PROTECTIVE_EQUIPMENT.getValue(), RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        List<RRiskBasicSource> safetyActivateListForNone = ((RiskBasicSourceCommonMapper)this.baseMapper).listWarningSourceForMaintenance(year, RiskTypeEnum.SAFETY_DEVICES_AND_ALERTS.getValue(), RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        List<RRiskBasicSource> Ex201ActivateListForNone = ((RiskBasicSourceCommonMapper)this.baseMapper).listWarningSourceForMaintenance(year, RiskTypeEnum.EXCEPTION_PERFORMANCE_TEST.getValue(), RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        List<RRiskBasicSource> Ex301ActivateListForNone = ((RiskBasicSourceCommonMapper)this.baseMapper).listWarningSourceForMaintenance(year, RiskTypeEnum.EXCEPTION_PLACE_TEST.getValue(), RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        List<RRiskBasicSource> Ex404ActivateListForNone = ((RiskBasicSourceCommonMapper)this.baseMapper).listWarningSourceForMaintenance(year, RiskTypeEnum.PHYSICAL_EXCEPTION_OCC.getValue(), RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        List<RRiskBasicSource> Ex405ActivateListForNone = ((RiskBasicSourceCommonMapper)this.baseMapper).listWarningSourceForMaintenance(year, RiskTypeEnum.PHYSICAL_EXCEPTION_CONTRAINDICATION.getValue(), RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        List<RRiskBasicSource> Ex406ActivateListForNone = ((RiskBasicSourceCommonMapper)this.baseMapper).listWarningSourceForMaintenance(year, RiskTypeEnum.PHYSICAL_EXCEPTION_REVIEW.getValue(), RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        List<RRiskBasicSource> Ex502ActivateListForNone = ((RiskBasicSourceCommonMapper)this.baseMapper).listWarningSourceForMaintenance(year, RiskTypeEnum.DOSE_EXCEPTION_OVERDOSE.getValue(), RiskWarningStatusEnum.ACTIVATE_LAW.getValue());
        activateLawList.addAll(performanceActivateListForNone);
        activateLawList.addAll(placeActivateListForNone);
        activateLawList.addAll(phyExamActivateListForNone);
        activateLawList.addAll(trainActivateListForNone);
        activateLawList.addAll(personalActivateListForNone);
        activateLawList.addAll(safetyActivateListForNone);
        activateLawList.addAll(Ex201ActivateListForNone);
        activateLawList.addAll(Ex301ActivateListForNone);
        activateLawList.addAll(Ex404ActivateListForNone);
        activateLawList.addAll(Ex405ActivateListForNone);
        activateLawList.addAll(Ex406ActivateListForNone);
        activateLawList.addAll(Ex502ActivateListForNone);
        if (!CollectionUtils.isEmpty(activateLawList)) {
            activateLawList.stream().forEach(source -> source.setWarningStatus(RiskWarningStatusEnum.RED.getValue()));
            this.updateBatchById(activateLawList);
            activateLawList = null;
        }
    }

    @Override
    public List<RRiskBasicSource> listRiskSourceAboutPhysical(SearchRiskParam param) {
        return ((RiskBasicSourceCommonMapper)this.baseMapper).listRiskSourceAboutPhysical(param);
    }

    @Override
    public List<RRiskBasicSource> getFcRiskForGen(Long staffBaseInfoId, Long cid, Integer riskPostType) {
        return ((RiskBasicSourceCommonMapper)this.baseMapper).getFcRiskForGen(staffBaseInfoId, cid, riskPostType, RiskTypeEnum.PHYSICAL_EXCEPTION_REVIEW.getValue());
    }

    @Override
    public List<Long> getAllHCNormalRiskForGenPreJobRiskTask(Long sbId, Long cid, Integer currYear) {
        return ((RiskBasicSourceCommonMapper)this.baseMapper).getAllHCNormalRiskForGenPreJobRiskTask(sbId, cid, currYear, RiskPostStatusEnum.PRE_POST.getValue(), RiskTypeEnum.PHYSICAL_EXAMINATION.getValue());
    }

    @Override
    public List<Long> getHCExceptionRiskForGenPreJobRiskTask(Long sbId, Long cid, Integer riskType, Integer currYear) {
        return ((RiskBasicSourceCommonMapper)this.baseMapper).getHCExceptionRiskForGenPreJobRiskTask(sbId, cid, currYear, RiskPostStatusEnum.PRE_POST.getValue(), riskType);
    }

    @Override
    public List<Long> getAllHCNormalRiskForGenDtJobRiskTask(Long sbId, Long cid, Integer currYear) {
        return ((RiskBasicSourceCommonMapper)this.baseMapper).getAllHCNormalRiskForGenDtJobRiskTask(sbId, cid, currYear, RiskPostStatusEnum.DT_POST.getValue(), RiskTypeEnum.PHYSICAL_EXAMINATION.getValue());
    }

    @Override
    public List<Long> getHCExceptionRiskForGenDtJobRiskTask(Long sbId, Long cid, Integer riskType, Integer currYear) {
        return ((RiskBasicSourceCommonMapper)this.baseMapper).getHCExceptionRiskForGenDtJobRiskTask(sbId, cid, currYear, RiskPostStatusEnum.DT_POST.getValue(), riskType);
    }

    @Override
    public List<Long> getAllHCNormalRiskForGenOnJobRiskTask(Long sbId, Long cid, Integer currYear) {
        return ((RiskBasicSourceCommonMapper)this.baseMapper).getAllHCNormalRiskForGenOnJobRiskTask(sbId, cid, currYear, RiskPostStatusEnum.ON_POST.getValue(), RiskTypeEnum.PHYSICAL_EXAMINATION.getValue());
    }

    @Override
    public List<Long> getHCExceptionRiskForGenOnJobRiskTask(Long sbId, Long cid, Integer riskType, Integer currYear) {
        return ((RiskBasicSourceCommonMapper)this.baseMapper).getHCExceptionRiskForGenOnJobRiskTask(sbId, cid, currYear, RiskPostStatusEnum.ON_POST.getValue(), riskType);
    }

    @Override
    public List<RRiskBasicSource> getHealthCheckPreJobRisk2Defuse(Integer year, List<Long> cidList) {
        return ((RiskBasicSourceCommonMapper)this.baseMapper).getHealthCheckPreJobRisk2Defuse(year, RiskTypeEnum.PHYSICAL_EXAMINATION.getValue(), RiskPostStatusEnum.PRE_POST.getValue(), cidList);
    }

    @Override
    public List<Long> getHealthCheckPreJobRiskIdList2Defuse(List<Long> cidList) {
        return ((RiskBasicSourceCommonMapper)this.baseMapper).getHealthCheckPreJobRiskIdList2Defuse(cidList);
    }

    @Override
    public List<RRiskBasicSource> getHealthCheckOnJobRisk2Defuse(Integer year, List<Long> cidList) {
        return ((RiskBasicSourceCommonMapper)this.baseMapper).getHealthCheckOnJobRisk2Defuse(year, RiskTypeEnum.PHYSICAL_EXAMINATION.getValue(), RiskPostStatusEnum.ON_POST.getValue(), cidList);
    }

    @Override
    public List<Long> getHealthCheckOnJobRiskIdList2Defuse(List<Long> cidList) {
        return ((RiskBasicSourceCommonMapper)this.baseMapper).getHealthCheckOnJobRiskIdList2Defuse(cidList);
    }

    @Override
    public List<RRiskBasicSource> getHealthCheckDtJobRisk2Defuse(Integer year, List<Long> cidList) {
        return ((RiskBasicSourceCommonMapper)this.baseMapper).getHealthCheckDtJobRisk2Defuse(year, RiskTypeEnum.PHYSICAL_EXAMINATION.getValue(), RiskPostStatusEnum.DT_POST.getValue(), cidList);
    }

    @Override
    public List<Long> getHealthCheckDtJobRiskIdList2Defuse(List<Long> cidList) {
        return ((RiskBasicSourceCommonMapper)this.baseMapper).getHealthCheckDtJobRiskIdList2Defuse(cidList);
    }

    @Override
    public RRiskBasicSource getLastRiskForCommonGenDoseRisk(Long staffBaseInfoId, Long cid) {
        return ((RiskBasicSourceCommonMapper)this.baseMapper).getLastRiskForCommonGenDoseRisk(staffBaseInfoId, cid);
    }

    @Override
    public RRiskBasicSource getLastRiskForErrorGenDoseRisk(Long staffBaseInfoId, Long cid, LocalDateTime start) {
        return ((RiskBasicSourceCommonMapper)this.baseMapper).getLastRiskForErrorGenDoseRisk(staffBaseInfoId, cid, start);
    }

    @Override
    public RRiskBasicSource getCmCertRiskForGen(Long cid) {
        return ((RiskBasicSourceCommonMapper)this.baseMapper).getCmCertRiskForGen(cid);
    }

    @Override
    @Transactional
    public void deleteByBaseIdAndCid(Long baseId, Long cid) {
        ((RiskBasicSourceCommonMapper)this.baseMapper).deleteByBaseIdAndCid(baseId, cid);
    }

    @Override
    public RRiskBasicSource getExEnFieldForRisk(Long rid) {
        return ((RiskBasicSourceCommonMapper)this.baseMapper).getExEnFieldForRisk(rid);
    }
}

