/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.risk.impl;

import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.core.framework.model.LayuiGridParam;
import cn.smarthse.rho.modules.sys.converter.r.RiskAcceptanceRecordConverter;
import cn.smarthse.rho.modules.sys.dao.risk.RiskAcceptanceRecordHistoryCommonMapper;
import cn.smarthse.rho.modules.sys.entity.r.RRiskAcceptanceRecord;
import cn.smarthse.rho.modules.sys.entity.r.RRiskAcceptanceRecordHistory;
import cn.smarthse.rho.modules.sys.enums.risk.RiskAcceptanceWayEnum;
import cn.smarthse.rho.modules.sys.model.r.param.RiskQueryCommonParam;
import cn.smarthse.rho.modules.sys.model.r.vo.RiskAcceptanceHistoryVo;
import cn.smarthse.rho.modules.sys.provider.sys.ISysFileProvider;
import cn.smarthse.rho.modules.sys.service.risk.IRiskAcceptanceRecordHistoryCommonService;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(readOnly=true)
public class RiskAcceptanceRecordHistoryCommonServiceImpl
extends ServiceImpl<RiskAcceptanceRecordHistoryCommonMapper, RRiskAcceptanceRecordHistory>
implements IRiskAcceptanceRecordHistoryCommonService {
    @DubboReference
    private ISysFileProvider sysFileProvider;
    @Autowired
    private RiskAcceptanceRecordConverter converter;

    @Override
    public LayuiGridData<RiskAcceptanceHistoryVo> listAcceptanceHistory(RiskQueryCommonParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<RiskAcceptanceHistoryVo> rst = ((RiskAcceptanceRecordHistoryCommonMapper)this.baseMapper).listAcceptanceHistory(param);
        if (!CollectionUtils.isEmpty(rst)) {
            for (RiskAcceptanceHistoryVo vo : rst) {
                vo.setAcceptanceFilesURL(this.sysFileProvider.getFileVoByIds(vo.getReformFinishedFiles()));
                vo.setReformFinishedFilesURL(this.sysFileProvider.getFileVoByIds(vo.getReformFinishedFiles()));
            }
        }
        return new LayuiGridData((Page)rst, (LayuiGridParam)param);
    }

    @Override
    @Transactional
    public void saveHistoryForResolvedRisk(RRiskAcceptanceRecord record) {
        if (record == null) {
            return;
        }
        RRiskAcceptanceRecordHistory history = this.converter.record2recordHistory(record);
        history.setId(Long.valueOf(IdWorker.getId()));
        history.setAccId(record.getId());
        history.setCreateDate(LocalDateTime.now());
        history.setUpdateDate(LocalDateTime.now());
        this.save(history);
    }

    @Override
    public RiskAcceptanceHistoryVo getHistoryAcceptRecord(Long sourceId) {
        RiskQueryCommonParam param = new RiskQueryCommonParam().setSourceId(sourceId);
        List<RiskAcceptanceHistoryVo> historyList = ((RiskAcceptanceRecordHistoryCommonMapper)this.baseMapper).listAcceptanceHistory(param);
        if (CollectionUtils.isEmpty(historyList)) {
            return null;
        }
        RiskAcceptanceHistoryVo firstRecord = historyList.get(0);
        if (firstRecord == null || firstRecord.getAcceptanceWay() == null || !firstRecord.getAcceptanceWay().equals(RiskAcceptanceWayEnum.SPECIAL_FOREVER.getValue())) {
            return null;
        }
        RiskAcceptanceHistoryVo historyVo = historyList.stream().filter(v -> v.getReformFinishedFiles() != null && !v.getReformFinishedFiles().isEmpty()).findFirst().orElse(null);
        if (historyVo != null) {
            historyVo.setAcceptanceFilesURL(this.sysFileProvider.getFileVoByIds(historyVo.getReformFinishedFiles()));
            historyVo.setReformFinishedFilesURL(this.sysFileProvider.getFileVoByIds(historyVo.getReformFinishedFiles()));
            return historyVo;
        }
        return null;
    }
}

