/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.risk.impl;

import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.rho.modules.sys.dao.risk.RiskAcceptanceRecordCommonMapper;
import cn.smarthse.rho.modules.sys.entity.r.RRiskAcceptanceRecord;
import cn.smarthse.rho.modules.sys.entity.r.RRiskBasicSource;
import cn.smarthse.rho.modules.sys.enums.risk.AcceptanceRecordStatusEnum;
import cn.smarthse.rho.modules.sys.model.r.vo.RiskAcceptanceCommonVo;
import cn.smarthse.rho.modules.sys.provider.sys.ISysFileProvider;
import cn.smarthse.rho.modules.sys.service.risk.IRiskAcceptanceRecordCommonService;
import cn.smarthse.rho.modules.sys.service.risk.IRiskAcceptanceRecordHistoryCommonService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(readOnly=true)
public class RiskAcceptanceRecordCommonServiceImpl
extends ServiceImpl<RiskAcceptanceRecordCommonMapper, RRiskAcceptanceRecord>
implements IRiskAcceptanceRecordCommonService {
    @DubboReference
    private ISysFileProvider sysFileProvider;
    @Autowired
    private IRiskAcceptanceRecordHistoryCommonService recordHistoryCommonService;

    @Override
    public List<RiskAcceptanceCommonVo> listAcceptanceRecordBySourceId(Long sourceId) {
        if (sourceId == null) {
            return null;
        }
        ArrayList<RiskAcceptanceCommonVo> rst = new ArrayList<RiskAcceptanceCommonVo>();
        RiskAcceptanceCommonVo bySourceId = ((RiskAcceptanceRecordCommonMapper)this.baseMapper).getAcceptanceBySourceId(sourceId);
        if (bySourceId != null && bySourceId.getStatus() != 0) {
            bySourceId.setReformDirectorNamePlaintext(null);
        }
        rst.add(((RiskAcceptanceRecordCommonMapper)this.baseMapper).getAcceptanceBySourceId(sourceId));
        rst.addAll(0, ((RiskAcceptanceRecordCommonMapper)this.baseMapper).listAcceptanceHistoryBySourceId(sourceId));
        for (RiskAcceptanceCommonVo vo : rst) {
            vo.setAcceptanceFilesURL(this.sysFileProvider.getFileVoByIds(vo.getAcceptanceFiles()));
            vo.setReformFinishedFilesURL(this.sysFileProvider.getFileVoByIds(vo.getReformFinishedFiles()));
        }
        return rst;
    }

    @Override
    public List<RRiskAcceptanceRecord> getAcceptRecordListBySourceIds(List<Long> riskBasicSourceIds) {
        if (CollectionUtils.isEmpty(riskBasicSourceIds)) {
            return null;
        }
        return ((RiskAcceptanceRecordCommonMapper)this.baseMapper).getAcceptRecordListBySourceIds(riskBasicSourceIds);
    }

    @Override
    public void updateAcceptanceForResolveOfCommon(List<Long> sourceIdList) {
        this.updateAcceptanceForResolveOfCommon(sourceIdList, null, null);
    }

    @Override
    @Transactional
    public void updateAcceptanceForResolveOfCommon(List<Long> sourceIdList, Integer acceptanceWay, String reformMeasure) {
        if (CollectionUtils.isEmpty(sourceIdList)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.in(RRiskAcceptanceRecord::getSourceId, sourceIdList)).set(RRiskAcceptanceRecord::getStatus, (Object)AcceptanceRecordStatusEnum.DONE.getValue())).set(RRiskAcceptanceRecord::getAcceptanceDate, (Object)LocalDate.now())).set(RRiskAcceptanceRecord::getAcceptanceWay, (Object)acceptanceWay)).set(RRiskAcceptanceRecord::getAcceptanceResultExplain, (Object)reformMeasure)).set(RRiskAcceptanceRecord::getAcceptanceDirectorName, (Object)SpringEncryptUtils.encrypt((String)"\u7cfb\u7edf\u81ea\u52a8\u6574\u6539\u9a8c\u6536"));
        this.update((Wrapper)updateWrapper);
    }

    @Override
    @Transactional
    public void saveHistoryAndResetStatus(RRiskBasicSource source) {
        if (source == null) {
            return;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(RRiskAcceptanceRecord::getSourceId, (Object)source.getId())).last("limit 1");
        RRiskAcceptanceRecord record = (RRiskAcceptanceRecord)this.getOne((Wrapper)queryWrapper);
        this.recordHistoryCommonService.saveHistoryForResolvedRisk(record);
        RRiskAcceptanceRecord updateRecord = new RRiskAcceptanceRecord();
        updateRecord.setId(record.getId());
        updateRecord.setRiskId(record.getId());
        updateRecord.setSourceId(record.getSourceId());
        updateRecord.setCid(record.getCid());
        updateRecord.setRiskType(record.getRiskType());
        updateRecord.setFindTime(source.getFindTime());
        updateRecord.setRequireFinishTime(source.getRequireFinishTime());
        updateRecord.setStatus(AcceptanceRecordStatusEnum.DRAFT.getValue());
        updateRecord.setCreateBy(record.getCreateBy());
        ((RiskAcceptanceRecordCommonMapper)this.baseMapper).alwaysUpdateSomeColumnById(updateRecord);
    }

    @Override
    public RRiskAcceptanceRecord getValidSupportingDocumentsHcRisk(Long sbId, Integer riskType, Integer riskPostType) {
        return ((RiskAcceptanceRecordCommonMapper)this.baseMapper).getValidSupportingDocumentsHcRisk(sbId, riskType, riskPostType);
    }

    @Override
    public Integer countSupportingDocumentsHcRiskForGen(Long cid, Long sbId, Integer riskType, Integer riskPostType) {
        return ((RiskAcceptanceRecordCommonMapper)this.baseMapper).countSupportingDocumentsHcRiskForGen(cid, sbId, riskType, riskPostType);
    }

    @Override
    public Integer countSupportingDocumentsHcRiskForGenError(Long cid, Long sbId, Integer riskType) {
        return ((RiskAcceptanceRecordCommonMapper)this.baseMapper).countSupportingDocumentsHcRiskForGenError(cid, sbId, riskType);
    }

    @Override
    public Integer countRiskForGen(Long cid, Long sbId, Integer riskType, Integer riskPostType) {
        return ((RiskAcceptanceRecordCommonMapper)this.baseMapper).countRiskForGen(cid, sbId, riskType, riskPostType);
    }

    @Override
    public Integer countRiskForGenError(Long cid, Long sbId, Integer riskType) {
        return ((RiskAcceptanceRecordCommonMapper)this.baseMapper).countRiskForGenError(cid, sbId, riskType);
    }
}

