/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.e.impl;

import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.rho.core.framework.model.BaseEntity;
import cn.smarthse.rho.modules.sys.converter.e.ERelationCommonConverter;
import cn.smarthse.rho.modules.sys.dao.e.ERelationMapper;
import cn.smarthse.rho.modules.sys.entity.e.ERelation;
import cn.smarthse.rho.modules.sys.enums.company.EdeviceTypeEnum;
import cn.smarthse.rho.modules.sys.model.e.param.ERelationDto;
import cn.smarthse.rho.modules.sys.service.e.IERelationCommonService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(readOnly=true)
public class ERelationCommonServiceImpl
extends ServiceImpl<ERelationMapper, ERelation>
implements IERelationCommonService {
    @Autowired
    private ERelationCommonConverter relationConverter;

    @Override
    public void addRelationForDevice(ERelation newRelation) {
        this.save(newRelation);
    }

    @Override
    @Transactional
    public void freeRoomRelationForDevice(Long deviceId) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.set(ERelation::getIsCur, (Object)0)).isNotNull(ERelation::getRoomId)).isNull(ERelation::getSourceId)).eq(ERelation::getDeviceId, (Object)deviceId)).eq(ERelation::getIsCur, (Object)1)).eq(BaseEntity::getIsValid, (Object)1);
        this.update((Wrapper)wrapper);
    }

    @Override
    @Transactional
    public void freeSourceRelationForDevice(Long deviceId) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.set(ERelation::getIsCur, (Object)0)).isNotNull(ERelation::getSourceId)).eq(ERelation::getDeviceId, (Object)deviceId)).eq(ERelation::getIsCur, (Object)1)).eq(BaseEntity::getIsValid, (Object)1);
        this.update((Wrapper)wrapper);
    }

    @Override
    @Transactional
    public void freeBatchRelationById(List<Long> relationIdList) {
        if (CollectionUtils.isEmpty(relationIdList)) {
            return;
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.set(ERelation::getIsCur, (Object)0)).in(ERelation::getId, relationIdList)).eq(ERelation::getIsCur, (Object)1)).eq(BaseEntity::getIsValid, (Object)1);
        this.update((Wrapper)wrapper);
    }

    @Override
    @Transactional
    public void addAssociationForSource(ERelation newRelation) {
        if (newRelation.getSourceId() == null) {
            throw new RuntimeException("\u7f3a\u5c11\u6838\u7d20\u4fe1\u606f\uff01");
        }
        newRelation.setId(null);
        newRelation.setIsCur(Integer.valueOf(1));
        this.save(newRelation);
    }

    @Override
    public void changeSourceOfRoomRelationForDevice(Long beforeRoomId, Long deviceId, Long afterRoomId) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(ERelation::getRoomId, (Object)afterRoomId)).eq(ERelation::getRoomId, (Object)beforeRoomId)).eq(ERelation::getDeviceId, (Object)deviceId)).eq(ERelation::getIsCur, (Object)1)).isNotNull(ERelation::getSourceId)).eq(BaseEntity::getIsValid, (Object)1);
        this.update((Wrapper)updateWrapper);
    }

    @Override
    public void delAssociationByRelationId(ERelationDto param) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(ERelation::getSourceId, (Object)param.getSourceId())).eq(ERelation::getRoomId, (Object)param.getRoomId())).eq(ERelation::getIsCur, (Object)1);
        if (param.getDeviceId() == null) {
            queryWrapper.isNull(ERelation::getDeviceId);
        } else {
            queryWrapper.eq(ERelation::getDeviceId, (Object)param.getDeviceId());
        }
        ERelation relation = (ERelation)this.getOne((Wrapper)queryWrapper);
        relation.setIsCur(Integer.valueOf(0));
        this.updateById(relation);
        relation.setId(null);
        relation.setBeforeChangeName(relation.getAfterChangeName());
        relation.setAfterChangeName("-");
        relation.setChangeDate(LocalDateTime.now());
        this.save(relation);
    }

    @Override
    @Transactional
    public void disassociateByDeviceIdAndType(Long deviceId, Integer type) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(ERelation::getIsCur, (Object)0)).eq(ERelation::getIsCur, (Object)1)).eq(BaseEntity::getIsValid, (Object)1);
        if (type == EdeviceTypeEnum.DEVICE_RAY.getValue() || type == EdeviceTypeEnum.DEVICE_SOURCE.getValue()) {
            updateWrapper.eq(ERelation::getDeviceId, (Object)deviceId);
        } else if (type == EdeviceTypeEnum.SOURCE_NON_SEALED.getValue() || type == EdeviceTypeEnum.SOURCE_SEALED.getValue()) {
            updateWrapper.eq(ERelation::getSourceId, (Object)deviceId);
        }
        this.update((Wrapper)updateWrapper);
    }

    @Override
    public void disassociateBySourceId(Long sourceId) {
    }

    @Override
    @Transactional
    public void updateAssociationForSource(Long sourceId, List<ERelation> newRelationList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(ERelation::getSourceId, (Object)sourceId)).eq(ERelation::getIsCur, (Object)1)).eq(BaseEntity::getIsValid, (Object)1);
        List curRelationList = this.list((Wrapper)queryWrapper);
        ArrayList<ERelation> needDisassociateRelation = new ArrayList<ERelation>();
        block0: for (ERelation curRelation : curRelationList) {
            for (ERelation newRelation : newRelationList) {
                if (curRelation.getRoomId() == newRelation.getRoomId() || curRelation.getDeviceId() == newRelation.getDeviceId()) continue;
                curRelation.setIsCur(Integer.valueOf(0));
                needDisassociateRelation.add(curRelation);
                continue block0;
            }
        }
        this.updateBatchById(needDisassociateRelation);
        if (!CollectionUtils.isEmpty(newRelationList)) {
            ArrayList<ERelation> establishRelation = new ArrayList<ERelation>();
            block2: for (ERelation newRelation : newRelationList) {
                for (ERelation curRelation : curRelationList) {
                    if (newRelation.getRoomId() == curRelation.getRoomId() || newRelation.getDeviceId() == curRelation.getDeviceId()) continue;
                    newRelation.setId(null);
                    newRelation.setIsCur(Integer.valueOf(1));
                    establishRelation.add(newRelation);
                    continue block2;
                }
            }
            this.saveBatch(establishRelation);
        }
    }

    @Override
    public String getRoomNameByBaseIdAndType(Long baseId, Integer type) {
        List<ERelationDto> relationList = this.listRelationByBaseIdAndType(baseId, type);
        if (!CollectionUtils.isEmpty(relationList)) {
            return relationList.stream().map(ERelationDto::getRoomName).collect(Collectors.joining(","));
        }
        return "";
    }

    @Override
    public List<ERelationDto> listRelationByBaseIdAndType(Long baseId, Integer type) {
        return ((ERelationMapper)this.baseMapper).listRelationByBaseIdAndType(baseId, type);
    }

    @Override
    @Transactional
    public void updateAssociationByBaseIdAndType(Long baseId, Integer type, List<ERelation> newRelationList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (Objects.equals(type, EdeviceTypeEnum.DEVICE_RAY.getValue()) || Objects.equals(type, EdeviceTypeEnum.DEVICE_SOURCE.getValue())) {
            queryWrapper.eq(ERelation::getDeviceId, (Object)baseId);
        } else if (Objects.equals(type, EdeviceTypeEnum.SOURCE_NON_SEALED.getValue()) || Objects.equals(type, EdeviceTypeEnum.SOURCE_SEALED.getValue())) {
            queryWrapper.eq(ERelation::getSourceId, (Object)baseId);
        }
        ((LambdaQueryWrapper)queryWrapper.eq(ERelation::getIsCur, (Object)1)).eq(BaseEntity::getIsValid, (Object)1);
        List curRelationList = this.list((Wrapper)queryWrapper);
        ArrayList<ERelation> needDisassociateRelation = new ArrayList<ERelation>();
        block0: for (ERelation curRelation : curRelationList) {
            for (ERelation newRelation : newRelationList) {
                if (curRelation.getRoomId() == newRelation.getRoomId() || curRelation.getDeviceId() == newRelation.getDeviceId()) continue;
                curRelation.setIsCur(Integer.valueOf(0));
                needDisassociateRelation.add(curRelation);
                continue block0;
            }
        }
        this.updateBatchById(needDisassociateRelation);
        if (!CollectionUtils.isEmpty(newRelationList)) {
            ArrayList<ERelation> establishRelation = new ArrayList<ERelation>();
            block2: for (ERelation newRelation : newRelationList) {
                for (ERelation curRelation : curRelationList) {
                    if (newRelation.getRoomId() == curRelation.getRoomId() || newRelation.getDeviceId() == curRelation.getDeviceId()) continue;
                    newRelation.setId(null);
                    newRelation.setIsCur(Integer.valueOf(1));
                    establishRelation.add(newRelation);
                    continue block2;
                }
            }
            this.saveBatch(establishRelation);
        }
    }
}

