/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.e.impl;

import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.rho.core.framework.Constant;
import cn.smarthse.rho.core.framework.model.BaseEntity;
import cn.smarthse.rho.modules.sys.dao.e.EDeviceCommonMapper;
import cn.smarthse.rho.modules.sys.entity.d.DDeviceCheck;
import cn.smarthse.rho.modules.sys.entity.d.DDeviceCheckData;
import cn.smarthse.rho.modules.sys.entity.e.EDevice;
import cn.smarthse.rho.modules.sys.entity.e.ERelation;
import cn.smarthse.rho.modules.sys.model.b.vo.license.ChangeLicenseDetailVo;
import cn.smarthse.rho.modules.sys.model.d.param.AddDeviceCheckByMaterialsParam;
import cn.smarthse.rho.modules.sys.model.e.vo.DeviceLocationStatisticVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EDeviceDetailVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EMachineRoomListVo;
import cn.smarthse.rho.modules.sys.model.e.vo.LocationDeviceStatisticVo;
import cn.smarthse.rho.modules.sys.model.r.param.RiskMangerGenParam;
import cn.smarthse.rho.modules.sys.model.r.vo.GenRiskAboutPerformanceVo;
import cn.smarthse.rho.modules.sys.service.e.IEDeviceCommonService;
import cn.smarthse.rho.modules.sys.service.e.IERelationCommonService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.util.ArrayList;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class EDeviceCommonServiceImpl
extends ServiceImpl<EDeviceCommonMapper, EDevice>
implements IEDeviceCommonService {
    @Autowired
    private IERelationCommonService eRelationCommonService;

    @Override
    public List<GenRiskAboutPerformanceVo> searchDeviceForPerformanceRiskTask(RiskMangerGenParam param) {
        ArrayList<GenRiskAboutPerformanceVo> list = new ArrayList<GenRiskAboutPerformanceVo>();
        list.addAll(((EDeviceCommonMapper)this.baseMapper).selectAllForPerformanceRiskTask(param));
        list.addAll(((EDeviceCommonMapper)this.baseMapper).selectAllForPerformanceRiskTaskByMaterials(param, 2));
        list.addAll(((EDeviceCommonMapper)this.baseMapper).selectAllForPerformanceRiskTaskByMaterials(param, 3));
        return list;
    }

    @Override
    public List<GenRiskAboutPerformanceVo> searchDeviceForPerformanceExceptionRiskTask() {
        return ((EDeviceCommonMapper)this.baseMapper).selectAllForPerformanceExceptionRiskTask();
    }

    @Override
    public List<EDevice> getForCycleLicense(Long cid) {
        if (cid == null) {
            throw new RuntimeException("cid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)wrapper.lambda().eq(EDevice::getCid, (Object)cid)).eq(BaseEntity::getIsValid, (Object)Constant.ACTIVE_YES);
        return this.list((Wrapper)wrapper);
    }

    @Override
    public EDevice getByFactoryNo(String deviceNo) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lambda().eq(EDevice::getFactoryNo, (Object)deviceNo)).eq(BaseEntity::getIsValid, (Object)Constant.ACTIVE_YES)).last("limit 1");
        return (EDevice)this.getOne((Wrapper)wrapper);
    }

    @Override
    public EDeviceDetailVo getEDeviceDetailVo(Long did) {
        return ((EDeviceCommonMapper)this.baseMapper).getEDeviceDetailVo(did);
    }

    @Override
    public List<LocationDeviceStatisticVo> getLocationDevicesNumByLocationIds(List<Long> locationIds, Long cid) {
        return ((EDeviceCommonMapper)this.baseMapper).getLocationDevicesNumByLocationIds(locationIds, cid);
    }

    @Override
    public DeviceLocationStatisticVo getDevicesLocationByDeviceIds(Long deviceId, Integer deviceType, Long cid) {
        return ((EDeviceCommonMapper)this.baseMapper).getDevicesLocationByDeviceIds(deviceId, deviceType, cid);
    }

    @Override
    @Transactional
    public void updateERelationBySupConfirm(Long deviceId, List<ERelation> relationList) {
        EDevice device = (EDevice)this.getById(deviceId);
        if (device == null) {
            throw new ServiceException("\u8bbe\u5907\u4e0d\u5b58\u5728");
        }
        this.eRelationCommonService.updateAssociationByBaseIdAndType(deviceId, device.getType(), relationList);
    }

    @Override
    public ChangeLicenseDetailVo getDeviceDetailForLicense(Long deviceId) {
        EDevice device = (EDevice)this.getById(deviceId);
        if (device == null) {
            return null;
        }
        ChangeLicenseDetailVo rst = new ChangeLicenseDetailVo();
        rst.setDeviceId(device.getId());
        rst.setDeviceName(device.getName());
        rst.setDeviceType(device.getType());
        rst.setDeviceFactoryNo(device.getFactoryNo());
        rst.setLastCheckTime(((EDeviceCommonMapper)this.baseMapper).getLastCheckTimeForDevice(deviceId));
        rst.setLocationName(this.eRelationCommonService.getRoomNameByBaseIdAndType(device.getId(), device.getType()));
        return rst;
    }

    @Override
    public List<EMachineRoomListVo> listRelationMachineRoomByDId(Long id) {
        return ((EDeviceCommonMapper)this.baseMapper).listRelationMachineRoomByDId(id);
    }

    @Override
    @Transactional
    public void saveDeviceCheckDataByMaterials(AddDeviceCheckByMaterialsParam param) {
        EDevice device = (EDevice)this.getById(param.getDeviceId());
        DDeviceCheck deviceCheck = new DDeviceCheck();
        deviceCheck.setId(Long.valueOf(IdWorker.getId()));
        deviceCheck.setCid(param.getCid());
        deviceCheck.setOrgName(param.getOrgName());
        deviceCheck.setCheckTime(param.getCheckTime());
        deviceCheck.setType(param.getType());
        deviceCheck.setReportNo(param.getReportNo());
        deviceCheck.setReportUrl(param.getReportUrl());
        deviceCheck.setCreateBy(param.getUserId());
        deviceCheck.setUpdateBy(param.getUserId());
        ((EDeviceCommonMapper)this.baseMapper).insertDeviceCheck(deviceCheck);
        DDeviceCheckData deviceCheckData = new DDeviceCheckData();
        deviceCheckData.setId(Long.valueOf(IdWorker.getId()));
        deviceCheckData.setCheckId(deviceCheck.getId());
        deviceCheckData.setCid(deviceCheck.getCid());
        deviceCheckData.setDeviceId(param.getDeviceId());
        deviceCheckData.setDeviceName(device.getName());
        deviceCheckData.setDeviceType(device.getType());
        deviceCheckData.setFactoryNo(device.getFactoryNo());
        deviceCheckData.setCheckResult(param.getCheckResult());
        deviceCheckData.setCheckTime(param.getCheckTime());
        deviceCheckData.setCreateBy(param.getUserId());
        deviceCheckData.setUpdateBy(param.getUserId());
        ((EDeviceCommonMapper)this.baseMapper).insertDeviceCheckData(deviceCheckData);
    }
}

