/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.c.impl;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.core.framework.model.LayuiGridParam;
import cn.smarthse.rho.modules.sys.dao.c.CStatisticMapper;
import cn.smarthse.rho.modules.sys.entity.c.CStatistic;
import cn.smarthse.rho.modules.sys.model.c.param.StaffStatisticsParam;
import cn.smarthse.rho.modules.sys.model.c.param.staff.DataReportStaffParam;
import cn.smarthse.rho.modules.sys.model.c.vo.staff.DataReportStaffVo;
import cn.smarthse.rho.modules.sys.service.c.ICStatisticService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CStatisticServiceImpl
extends ServiceImpl<CStatisticMapper, CStatistic>
implements ICStatisticService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CStatisticServiceImpl.class);

    @Override
    @Transactional
    public void statisticsAll(StaffStatisticsParam param) {
        try {
            this.initData(param);
            this.statisticsWarning(param);
            this.statisticsHealthNum(param);
            this.statisticsDoseNum(param);
            this.statisticsTrainingNum(param);
            this.statisticsRiskNum(param);
        }
        catch (Exception e) {
            log.error("\u3010\u4eba\u5458\u7edf\u8ba1\u3011\u3010\u521d\u59cb\u5316\u3011\u6267\u884c\u5931\u8d25\uff1a{}", (Throwable)e);
        }
    }

    @Override
    @Transactional
    public void initData(StaffStatisticsParam param) {
        try {
            ((CStatisticMapper)this.baseMapper).initData();
        }
        catch (Exception e) {
            log.error("\u3010\u4eba\u5458\u7edf\u8ba1\u3011\u3010\u521d\u59cb\u5316\u3011\u6267\u884c\u5931\u8d25\uff1a{}", (Throwable)e);
        }
    }

    @Override
    @Transactional
    public void statisticsWarning(StaffStatisticsParam param) {
        try {
            ((CStatisticMapper)this.baseMapper).updateDoseWarning(param);
            ((CStatisticMapper)this.baseMapper).updateTrainingWarning(param);
            ((CStatisticMapper)this.baseMapper).updateHealthWarning(param);
            ((CStatisticMapper)this.baseMapper).updateBigDoseWarning(param);
            ((CStatisticMapper)this.baseMapper).updateBigYearDoseWarning(param);
        }
        catch (Exception e) {
            log.error("\u3010\u4eba\u5458\u7edf\u8ba1\u3011\u3010\u98ce\u9669\u9884\u8b66\u3011\u5931\u8d25\uff1a{}", (Throwable)e);
        }
    }

    @Override
    @Transactional
    public void statisticsHealthNum(StaffStatisticsParam param) {
        try {
            ((CStatisticMapper)this.baseMapper).statisticsHealthNum(param);
        }
        catch (Exception e) {
            log.error("\u3010\u4eba\u5458\u7edf\u8ba1\u3011\u3010\u4f53\u68c0\u6b21\u6570-\u5e74\u5ea6\u3011\u6267\u884c\u5931\u8d25\uff1a{}", (Throwable)e);
        }
    }

    @Override
    @Transactional
    public void statisticsDoseNum(StaffStatisticsParam param) {
        try {
            ((CStatisticMapper)this.baseMapper).statisticsDoseNum(param);
        }
        catch (Exception e) {
            log.error("\u3010\u4eba\u5458\u7edf\u8ba1\u3011\u3010\u4e2a\u4eba\u5242\u91cf-\u7d2f\u8ba1\u3011\u6267\u884c\u5931\u8d25\uff1a{}", (Throwable)e);
        }
    }

    @Override
    public void statisticsRiskNum(StaffStatisticsParam param) {
        try {
            ((CStatisticMapper)this.baseMapper).statisticsRiskNum(param);
        }
        catch (Exception e) {
            log.error("\u3010\u4eba\u5458\u7edf\u8ba1\u3011\u3010\u98ce\u9669\u3011\u6267\u884c\u5931\u8d25\uff1a{}", (Throwable)e);
        }
    }

    @Override
    public void statisticsTrainingNum(StaffStatisticsParam param) {
        try {
            ((CStatisticMapper)this.baseMapper).statisticsTrainingNum(param);
        }
        catch (Exception e) {
            log.error("\u3010\u4eba\u5458\u7edf\u8ba1\u3011\u3010\u57f9\u8bad-\u7d2f\u8ba1\u3011\u6267\u884c\u5931\u8d25\uff1a{}", (Throwable)e);
        }
    }

    @Override
    public LayuiGridData<DataReportStaffVo> getStaffDataReport(DataReportStaffParam param) {
        LayuiGridData<DataReportStaffVo> result = null;
        result = param.getShowAllType() == null || param.getShowAllType() == 0 ? this.getStaffDataReportCommon(param) : this.getStaffDataReportForAllOneLevel(param);
        return result;
    }

    @Override
    public DataReportStaffVo getDataReportTotal(DataReportStaffParam param) {
        return ((CStatisticMapper)this.baseMapper).getDataReportTotal(param);
    }

    @Override
    public LayuiGridData<DataReportStaffVo> getStaffDataReportCommon(DataReportStaffParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<DataReportStaffVo> areaList = ((CStatisticMapper)this.baseMapper).getStaffDataReportAreaList(param);
        if (CollUtil.isEmpty(areaList)) {
            return new LayuiGridData(null, (LayuiGridParam)param);
        }
        List areaIdList = areaList.stream().map(v -> v.getAreaId()).collect(Collectors.toList());
        param.setAreaIdList(areaIdList);
        List<DataReportStaffVo> dataReportList = ((CStatisticMapper)this.baseMapper).getDataReport(param);
        Map<Long, List<DataReportStaffVo>> dataReportListMap = dataReportList.stream().collect(Collectors.groupingBy(DataReportStaffVo::getAreaId));
        for (DataReportStaffVo vo : areaList) {
            if (!dataReportListMap.containsKey(vo.getAreaId())) continue;
            DataReportStaffVo dataReport = dataReportListMap.get(vo.getAreaId()).get(0);
            vo.setStaffNum(dataReport.getStaffNum());
            vo.setCurrYearHealthManTime(dataReport.getCurrYearHealthManTime());
            vo.setSumSuspectedOccDiseaseManTime(dataReport.getSumSuspectedOccDiseaseManTime());
            vo.setSumOccContraindicationManTime(dataReport.getSumOccContraindicationManTime());
            vo.setCurrYearTrainingStaffNum(dataReport.getCurrYearTrainingStaffNum());
            vo.setDoseStaffNum(dataReport.getDoseStaffNum());
            vo.setBigDoseStaffNum(dataReport.getBigDoseStaffNum());
            vo.setYearDoseStaffNum(dataReport.getYearDoseStaffNum());
        }
        if (param.getLevel() == 2) {
            DataReportStaffVo cityLevelData = ((CStatisticMapper)this.baseMapper).getDataCityLevel(param);
            if (cityLevelData == null) {
                cityLevelData = new DataReportStaffVo();
                cityLevelData.setAreaId(param.getAreaId());
                cityLevelData.setAreaName(param.getAreaName());
            }
            cityLevelData.setAreaName(cityLevelData.getAreaName() + "\u672c\u7ea7");
            cityLevelData.setIsCityLevel(Integer.valueOf(1));
            areaList.add(0, cityLevelData);
        }
        return new LayuiGridData((Page)areaList, (LayuiGridParam)param);
    }

    @Override
    public LayuiGridData<DataReportStaffVo> getStaffDataReportForAllOneLevel(DataReportStaffParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<DataReportStaffVo> areaList = ((CStatisticMapper)this.baseMapper).getStaffDataReportAreaListForAllOneLevel(param);
        if (CollUtil.isEmpty(areaList)) {
            return new LayuiGridData(null, (LayuiGridParam)param);
        }
        List areaIdList = areaList.stream().map(v -> v.getAreaId()).collect(Collectors.toList());
        param.setAreaIdList(areaIdList);
        List<DataReportStaffVo> dataReportList = ((CStatisticMapper)this.baseMapper).getDataReportForAllOneLevel(param);
        Map<Long, List<DataReportStaffVo>> dataReportListMap = dataReportList.stream().collect(Collectors.groupingBy(DataReportStaffVo::getAreaId));
        for (DataReportStaffVo vo : areaList) {
            if (!dataReportListMap.containsKey(vo.getAreaId())) continue;
            DataReportStaffVo dataReport = dataReportListMap.get(vo.getAreaId()).get(0);
            vo.setStaffNum(dataReport.getStaffNum());
            vo.setCurrYearHealthManTime(dataReport.getCurrYearHealthManTime());
            vo.setSumSuspectedOccDiseaseManTime(dataReport.getSumSuspectedOccDiseaseManTime());
            vo.setSumOccContraindicationManTime(dataReport.getSumOccContraindicationManTime());
            vo.setCurrYearTrainingStaffNum(dataReport.getCurrYearTrainingStaffNum());
            vo.setDoseStaffNum(dataReport.getDoseStaffNum());
            vo.setBigDoseStaffNum(dataReport.getBigDoseStaffNum());
            vo.setYearDoseStaffNum(dataReport.getYearDoseStaffNum());
        }
        if (param.getLevel() == 2) {
            DataReportStaffVo cityLevelData = ((CStatisticMapper)this.baseMapper).getDataCityLevel(param);
            if (cityLevelData == null) {
                cityLevelData = new DataReportStaffVo();
                cityLevelData.setAreaId(param.getAreaId());
                cityLevelData.setAreaName(param.getAreaName());
            }
            cityLevelData.setAreaName(cityLevelData.getAreaName() + "\u672c\u7ea7");
            cityLevelData.setIsCityLevel(Integer.valueOf(0));
            areaList.add(0, cityLevelData);
        }
        return new LayuiGridData((Page)areaList, (LayuiGridParam)param);
    }

    @Generated
    public CStatisticServiceImpl() {
    }
}

