/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.c.impl;

import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.rho.core.framework.ShiroCommonUtil;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.core.framework.model.LayuiGridParam;
import cn.smarthse.rho.modules.sys.converter.c.CStaffWorkExperienceRecordConverter;
import cn.smarthse.rho.modules.sys.dao.c.CStaffWorkExperienceRecordMapper;
import cn.smarthse.rho.modules.sys.entity.b.BOrg;
import cn.smarthse.rho.modules.sys.entity.b.BPost;
import cn.smarthse.rho.modules.sys.entity.c.CStaffWorkExperience;
import cn.smarthse.rho.modules.sys.entity.c.CStaffWorkExperienceRecord;
import cn.smarthse.rho.modules.sys.model.b.vo.company.CompanyAddressVo;
import cn.smarthse.rho.modules.sys.model.c.param.wordExperience.StaffWorkExperienceRecordPageParam;
import cn.smarthse.rho.modules.sys.model.c.vo.experience.StaffWorkExperienceRecordVo;
import cn.smarthse.rho.modules.sys.provider.company.IBCompanyAddressProvider;
import cn.smarthse.rho.modules.sys.service.b.IBOrgService;
import cn.smarthse.rho.modules.sys.service.b.IBPostService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffWorkExperienceRecordService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.time.LocalDateTime;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CStaffWorkExperienceServiceRecordImpl
extends ServiceImpl<CStaffWorkExperienceRecordMapper, CStaffWorkExperienceRecord>
implements ICStaffWorkExperienceRecordService {
    private final CStaffWorkExperienceRecordConverter converter;
    private final IBPostService postService;
    private final IBOrgService orgService;
    private final IBCompanyAddressProvider companyAddressProvider;

    @Override
    @Transactional
    public void addRecord(CStaffWorkExperience newest, Integer editType) {
        if (newest == null || editType == null) {
            throw new ServiceException("\u53c2\u6570\u9519\u8bef\uff0c\u65e0\u6cd5\u751f\u6210\u8bb0\u5f55");
        }
        CStaffWorkExperienceRecord record = this.converter.source2Record(newest);
        if (newest.getPost() != null) {
            BPost post = (BPost)this.postService.getById(newest.getPost());
            record.setPostName(post.getName());
        }
        if (newest.getOrgId() != null) {
            BOrg org = (BOrg)this.orgService.getById(newest.getOrgId());
            record.setOrgName(org.getName());
        }
        record.setId(null);
        record.setExperienceId(newest.getId());
        record.setEditorId(ShiroCommonUtil.getJWTUserId());
        record.setEditTime(LocalDateTime.now());
        record.setEditType(editType);
        this.save(record);
    }

    @Override
    public LayuiGridData<StaffWorkExperienceRecordVo> getRecordList(StaffWorkExperienceRecordPageParam param) {
        if (param.getExperienceId() == null) {
            throw new ServiceException("\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5");
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<StaffWorkExperienceRecordVo> list = ((CStaffWorkExperienceRecordMapper)this.baseMapper).getRecordList(param);
        for (StaffWorkExperienceRecordVo vo : list) {
            CompanyAddressVo companyAddressVo = this.companyAddressProvider.getOneAddressVo(vo.getSubCid());
            vo.setCompanyAddressVo(companyAddressVo);
        }
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Generated
    public CStaffWorkExperienceServiceRecordImpl(CStaffWorkExperienceRecordConverter converter, IBPostService postService, IBOrgService orgService, IBCompanyAddressProvider companyAddressProvider) {
        this.converter = converter;
        this.postService = postService;
        this.orgService = orgService;
        this.companyAddressProvider = companyAddressProvider;
    }
}

