/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.c.impl;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.rho.modules.sys.converter.c.CStaffWorkExperienceConverter;
import cn.smarthse.rho.modules.sys.dao.c.CStaffWorkExperienceMapper;
import cn.smarthse.rho.modules.sys.entity.b.BOrg;
import cn.smarthse.rho.modules.sys.entity.b.BPost;
import cn.smarthse.rho.modules.sys.entity.c.CStaffWorkExperience;
import cn.smarthse.rho.modules.sys.model.c.param.CStaffWorkExperienceEditParam;
import cn.smarthse.rho.modules.sys.model.c.vo.CStaffWorkExperienceVo;
import cn.smarthse.rho.modules.sys.service.b.IBOrgService;
import cn.smarthse.rho.modules.sys.service.b.IBPostService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffErrorService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffWorkExperienceRecordService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffWorkExperienceService;
import java.time.LocalDateTime;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CStaffWorkExperienceServiceImpl
extends ServiceImpl<CStaffWorkExperienceMapper, CStaffWorkExperience>
implements ICStaffWorkExperienceService {
    private final CStaffWorkExperienceConverter cStaffWorkExperienceConverter;
    private final ICStaffWorkExperienceRecordService recordService;
    private final IBPostService postService;
    private final IBOrgService orgService;
    @Autowired
    @Lazy
    private ICStaffErrorService staffErrorService;

    @Override
    public CStaffWorkExperience getNewestInfo(Long staffBaseInfoId, Long cid) {
        return ((CStaffWorkExperienceMapper)this.baseMapper).getNewestInfo(staffBaseInfoId, cid);
    }

    @Override
    public CStaffWorkExperience getNewestForSdAuditedEdit(Long staffBaseInfoId, Long cid) {
        return ((CStaffWorkExperienceMapper)this.baseMapper).getNewestInfo(staffBaseInfoId, cid);
    }

    @Override
    public List<CStaffWorkExperience> getListForRisk(Long staffBaseInfoId, LocalDateTime limitTime) {
        return ((CStaffWorkExperienceMapper)this.baseMapper).getListForRisk(staffBaseInfoId, limitTime);
    }

    @Override
    @Transactional
    public CStaffWorkExperienceVo add(CStaffWorkExperienceEditParam param) {
        CStaffWorkExperience cStaffWorkExperience = this.cStaffWorkExperienceConverter.param2Entity(param);
        if (cStaffWorkExperience.getId() != null) {
            throw new ServiceException("\u5b58\u50a8\u6570\u636e\u5f02\u5e38");
        }
        if (param.getCid() == null) {
            throw new ServiceException("\u7f3a\u5c11\u516c\u53f8\u4fe1\u606f");
        }
        if (param.getStaffBaseInfoId() == null) {
            throw new ServiceException("\u7f3a\u5c11\u4eba\u5458\u4fe1\u606f");
        }
        if (param.getPost() == null || param.getOrgId() == null) {
            throw new ServiceException("\u7f3a\u5c11\u90e8\u95e8\u6216\u8005\u5c97\u4f4d");
        }
        BPost post = (BPost)this.postService.getById(param.getPost());
        BOrg org = (BOrg)this.orgService.getById(param.getOrgId());
        if (post == null || org == null) {
            throw new ServiceException("\u90e8\u95e8\u6216\u8005\u5c97\u4f4d\u4e0d\u5b58\u5728");
        }
        cStaffWorkExperience.setPostName(post.getName());
        cStaffWorkExperience.setOrgName(org.getName());
        this.save(cStaffWorkExperience);
        CStaffWorkExperience newest = (CStaffWorkExperience)this.getById(cStaffWorkExperience.getId());
        this.recordService.addRecord(newest, 1);
        this.staffErrorService.manualMaintenanceOne(param.getStaffBaseInfoId());
        return null;
    }

    @Override
    @Transactional
    public CStaffWorkExperienceVo edit(CStaffWorkExperienceEditParam param) {
        CStaffWorkExperience cStaffWorkExperience = this.cStaffWorkExperienceConverter.param2Entity(param);
        if (cStaffWorkExperience.getId() == null) {
            throw new ServiceException("\u66f4\u65b0\u6570\u636e\u5f02\u5e38");
        }
        if (param.getPost() == null || param.getOrgId() == null) {
            throw new ServiceException("\u7f3a\u5c11\u90e8\u95e8\u6216\u8005\u5c97\u4f4d");
        }
        BPost post = (BPost)this.postService.getById(param.getPost());
        BOrg org = (BOrg)this.orgService.getById(param.getOrgId());
        if (post == null || org == null) {
            throw new ServiceException("\u90e8\u95e8\u6216\u8005\u5c97\u4f4d\u4e0d\u5b58\u5728");
        }
        cStaffWorkExperience.setPostName(post.getName());
        cStaffWorkExperience.setOrgName(org.getName());
        this.updateById(cStaffWorkExperience);
        if (cStaffWorkExperience.getPostDepartureTime() == null) {
            ((CStaffWorkExperienceMapper)this.baseMapper).cleanDepartureTime(cStaffWorkExperience.getId());
        }
        if (cStaffWorkExperience.getTpPostDepartureTime() == null) {
            ((CStaffWorkExperienceMapper)this.baseMapper).cleanTpPostDepartureTime(cStaffWorkExperience.getId());
        }
        CStaffWorkExperience newest = (CStaffWorkExperience)this.getById(cStaffWorkExperience.getId());
        this.recordService.addRecord(newest, 2);
        this.staffErrorService.manualMaintenanceOne(newest.getStaffBaseInfoId());
        return this.cStaffWorkExperienceConverter.entity2Vo(cStaffWorkExperience);
    }

    @Override
    @Transactional
    public void delete(List<Long> idList) {
        if (CollUtil.isEmpty(idList)) {
            return;
        }
        Long id = idList.get(0);
        CStaffWorkExperience db = (CStaffWorkExperience)this.getById(id);
        if (db == null) {
            throw new ServiceException("\u5de5\u4f5c\u7ecf\u5386\u4e0d\u5b58\u5728\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
        Long staffBaseInfoId = db.getStaffBaseInfoId();
        Long cid = db.getCid();
        if (staffBaseInfoId == null || cid == null) {
            throw new ServiceException("\u5de5\u4f5c\u7ecf\u5386\u6570\u636e\u5f02\u5e38\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
        List<CStaffWorkExperience> excludeDbList = this.getListExcludeIds(staffBaseInfoId, cid, idList);
        if (CollUtil.isEmpty(excludeDbList)) {
            throw new ServiceException("\u65e0\u6cd5\u5220\u9664\u5168\u90e8\u5de5\u4f5c\u7ecf\u5386\uff0c\u9700\u4fdd\u7559\u4e00\u6761\uff0c\u5220\u9664\u5931\u8d25");
        }
        ((CStaffWorkExperienceMapper)this.baseMapper).deleteByIds(idList);
        this.staffErrorService.manualMaintenanceOne(staffBaseInfoId);
    }

    @Override
    public List<CStaffWorkExperience> getListExcludeIds(Long staffBaseInfoId, Long cid, List<Long> idList) {
        return ((CStaffWorkExperienceMapper)this.baseMapper).getListExcludeIds(staffBaseInfoId, cid, idList);
    }

    @Override
    public List<CStaffWorkExperience> getWorkExperienceListForPreJobRisk(Long staffBaseInfoId) {
        return ((CStaffWorkExperienceMapper)this.baseMapper).getWorkExperienceListForPreJobRisk(staffBaseInfoId);
    }

    @Override
    public CStaffWorkExperience getLastWorkExperienceForPreRiskV4(Long cid, Long staffBaseInfoId) {
        return ((CStaffWorkExperienceMapper)this.baseMapper).getLastWorkExperienceForPreRiskV4(cid, staffBaseInfoId);
    }

    @Override
    public CStaffWorkExperience getLastWorkExperienceForOnRiskV4(Long cid, Long staffBaseInfoId) {
        return ((CStaffWorkExperienceMapper)this.baseMapper).getLastWorkExperienceForOnRiskV4(cid, staffBaseInfoId);
    }

    @Override
    public CStaffWorkExperience getLastWorkExperienceForDtRiskV4(Long cid, Long staffBaseInfoId) {
        return ((CStaffWorkExperienceMapper)this.baseMapper).getLastWorkExperienceForDtRiskV4(cid, staffBaseInfoId);
    }

    @Override
    public List<CStaffWorkExperience> getWorkExperienceListForOnJobRisk(Long staffBaseInfoId) {
        return ((CStaffWorkExperienceMapper)this.baseMapper).getWorkExperienceListForOnJobRisk(staffBaseInfoId);
    }

    @Override
    public List<CStaffWorkExperience> getWorkExperienceListForDtJobRisk(Long staffBaseInfoId) {
        return ((CStaffWorkExperienceMapper)this.baseMapper).getWorkExperienceListForDtJobRisk(staffBaseInfoId);
    }

    @Override
    public CStaffWorkExperience getLastDataForMtErrorInfo(Long sbId, Long cid) {
        return ((CStaffWorkExperienceMapper)this.baseMapper).getLastDataForMtErrorInfo(sbId, cid);
    }

    @Override
    public LocalDateTime getNewestDtTimeForTrainingRisk(Long sbId, Long cid) {
        return ((CStaffWorkExperienceMapper)this.baseMapper).getNewestDtTimeForTrainingRisk(sbId, cid);
    }

    @Override
    public CStaffWorkExperience getForRiskById(Long id) {
        return ((CStaffWorkExperienceMapper)this.baseMapper).getForRiskById(id);
    }

    @Override
    public void deleteByBaseIdAndCid(Long sbId, Long cid) {
        ((CStaffWorkExperienceMapper)this.baseMapper).deleteByBaseIdAndCid(sbId, cid);
    }

    @Generated
    public CStaffWorkExperienceServiceImpl(CStaffWorkExperienceConverter cStaffWorkExperienceConverter, ICStaffWorkExperienceRecordService recordService, IBPostService postService, IBOrgService orgService) {
        this.cStaffWorkExperienceConverter = cStaffWorkExperienceConverter;
        this.recordService = recordService;
        this.postService = postService;
        this.orgService = orgService;
    }
}

