/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.c.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.PhoneUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.rho.modules.sys.dao.c.CStaffErrorMapper;
import cn.smarthse.rho.modules.sys.entity.c.CStaffError;
import cn.smarthse.rho.modules.sys.entity.c.CStaffWorkExperience;
import cn.smarthse.rho.modules.sys.enums.staff.PostStatusEnum;
import cn.smarthse.rho.modules.sys.model.c.param.staff.BStaffErrorMaintenanceParam;
import cn.smarthse.rho.modules.sys.model.c.param.staffErr.StaffErrInfoParam;
import cn.smarthse.rho.modules.sys.model.c.vo.staffErr.StaffErrVo;
import cn.smarthse.rho.modules.sys.model.c.vo.staffErr.StaffMaintenanceErrorInfo;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyErrorService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffErrorService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffWorkExperienceService;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CStaffErrorServiceImpl
extends ServiceImpl<CStaffErrorMapper, CStaffError>
implements ICStaffErrorService {
    @Autowired
    private ICStaffBaseInfoService staffBaseInfoService;
    @Autowired
    private IBCompanyErrorService companyErrorService;
    @Autowired
    private ICStaffErrorService self;
    @Autowired
    private ICStaffWorkExperienceService staffWorkExperienceService;

    @Override
    @Transactional
    public void maintenance(BStaffErrorMaintenanceParam param) {
        this.self.initData(param);
        this.self.initDataUp(param);
        this.self.maintenanceErrorInfo(param);
    }

    @Override
    @Transactional
    public void initData(BStaffErrorMaintenanceParam param) {
        ((CStaffErrorMapper)this.baseMapper).initData(param);
    }

    @Override
    @Transactional
    public void initDataUp(BStaffErrorMaintenanceParam param) {
        ((CStaffErrorMapper)this.baseMapper).initDataUp(param);
    }

    @Override
    @Transactional
    public void manualMaintenanceOne(Long sbId) {
        this.self.manualMaintenanceList(Collections.singletonList(sbId));
    }

    @Override
    @Transactional
    public void manualMaintenanceOne(Long sbId, Long cid) {
        this.self.manualMaintenanceList(Collections.singletonList(sbId));
        this.companyErrorService.manualMaintenanceOne(cid);
    }

    @Override
    @Transactional
    public void manualMaintenanceList(List<Long> sbIdList) {
        BStaffErrorMaintenanceParam param = new BStaffErrorMaintenanceParam();
        param.setSbIdList(sbIdList);
        this.self.maintenance(param);
        List<Long> cidList = this.staffBaseInfoService.getCidListForMtCompanyErrorInfo(sbIdList);
        if (CollUtil.isNotEmpty(cidList)) {
            this.companyErrorService.manualMaintenanceList(cidList);
        }
    }

    @Override
    @Transactional
    public void maintenanceErrorInfo(BStaffErrorMaintenanceParam param) {
        List<StaffMaintenanceErrorInfo> infoList = this.staffBaseInfoService.getListFtMtStaffErrorInfo(param);
        for (StaffMaintenanceErrorInfo info : infoList) {
            this.self.maintenanceOneErrorInfo(info);
        }
    }

    @Override
    @Transactional
    public void maintenanceOneErrorInfo(StaffMaintenanceErrorInfo info) {
        StaffMaintenanceErrorInfo dbMtInfo = this.staffBaseInfoService.getOneFtMtStaffErrorInfo(info.getSbId());
        info.setPhone(dbMtInfo.getPhone());
        info.setIdcard(dbMtInfo.getIdcard());
        CStaffError error = new CStaffError();
        error.setId(info.getErrorId());
        CStaffErrorServiceImpl.dealBaseInfo(info, error);
        CStaffWorkExperience we = this.staffWorkExperienceService.getLastDataForMtErrorInfo(info.getSbId(), info.getCid());
        if (we == null) {
            error.setWeErr(Integer.valueOf(1));
        } else if (info.getPostStatus() != null && info.getPostStatus().equals(PostStatusEnum.NON_POST.getValue()) && we.getPostDepartureTime() == null) {
            error.setWeErr(Integer.valueOf(2));
        } else {
            error.setWeErr(Integer.valueOf(0));
        }
        this.updateById(error);
    }

    private static void dealBaseInfo(StaffMaintenanceErrorInfo info, CStaffError error) {
        String idcard = info.getIdcard();
        String phone = info.getPhone();
        String raType = info.getRaType();
        Long post = info.getPost();
        Integer postStatus = info.getPostStatus();
        Long orgId = info.getOrgId();
        LocalDateTime rayStaffTime = info.getRayStaffTime();
        error.setStaffType(info.getStaffType());
        error.setManagerType(info.getManagerType());
        if (StrUtil.isBlank((CharSequence)idcard)) {
            error.setIdcardErr(Integer.valueOf(1));
        } else if (!IdcardUtil.isValidCard((String)idcard)) {
            error.setIdcardErr(Integer.valueOf(2));
        } else {
            error.setIdcardErr(Integer.valueOf(0));
        }
        if (StrUtil.isBlank((CharSequence)phone)) {
            error.setPhoneErr(Integer.valueOf(1));
        } else if (!PhoneUtil.isPhone((CharSequence)phone)) {
            error.setPhoneErr(Integer.valueOf(2));
        } else {
            error.setPhoneErr(Integer.valueOf(0));
        }
        if (post == null) {
            error.setPostErr(Integer.valueOf(1));
        } else {
            error.setPostErr(Integer.valueOf(0));
        }
        if (postStatus == null) {
            error.setPostStatusErr(Integer.valueOf(1));
        } else {
            error.setPostStatusErr(Integer.valueOf(0));
        }
        if (orgId == null) {
            error.setOrgErr(Integer.valueOf(1));
        } else {
            error.setOrgErr(Integer.valueOf(0));
        }
        if (StrUtil.isBlank((CharSequence)raType)) {
            error.setRaTypeErr(Integer.valueOf(1));
        } else {
            error.setRaTypeErr(Integer.valueOf(0));
        }
        if (rayStaffTime == null) {
            error.setRayStaffTimeErr(Integer.valueOf(1));
        } else {
            error.setRayStaffTimeErr(Integer.valueOf(0));
        }
    }

    @Override
    public StaffErrVo getOneCompanyStaffErrInfo(StaffErrInfoParam param) {
        if (param.getStaffBaseInfoId() == null || param.getCid() == null) {
            throw new ServiceException("\u65e0\u6cd5\u83b7\u53d6,\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5");
        }
        return ((CStaffErrorMapper)this.baseMapper).getOneCompanyStaffErrInfo(param);
    }

    @Override
    public List<StaffErrVo> getListCompanyStaffErrInfo(StaffErrInfoParam param) {
        if (param.getStaffBaseInfoId() == null) {
            throw new ServiceException("\u65e0\u6cd5\u83b7\u53d6,\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5");
        }
        return ((CStaffErrorMapper)this.baseMapper).getListCompanyStaffErrInfo(param);
    }
}

