/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.c.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.core.framework.model.LayuiGridParam;
import cn.smarthse.rho.core.framework.utils.RhoEncryptUtil;
import cn.smarthse.rho.modules.sys.dao.c.CStaffBaseInfoMapper;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.b.BOrg;
import cn.smarthse.rho.modules.sys.entity.b.BPost;
import cn.smarthse.rho.modules.sys.entity.c.CStaffBaseInfo;
import cn.smarthse.rho.modules.sys.enums.staff.PostStatusEnum;
import cn.smarthse.rho.modules.sys.model.b.param.check.ViewNumParam;
import cn.smarthse.rho.modules.sys.model.b.vo.CStaffInfoRangeVo;
import cn.smarthse.rho.modules.sys.model.b.vo.CStaffInfoSyncVo;
import cn.smarthse.rho.modules.sys.model.c.param.CStaffInfoRangeParam;
import cn.smarthse.rho.modules.sys.model.c.param.CertStaffChooseListParam;
import cn.smarthse.rho.modules.sys.model.c.param.StaffChangeLogParam;
import cn.smarthse.rho.modules.sys.model.c.param.StaffSelectInfoParam;
import cn.smarthse.rho.modules.sys.model.c.param.staff.BStaffErrorMaintenanceParam;
import cn.smarthse.rho.modules.sys.model.c.param.staff.CheckNameParam;
import cn.smarthse.rho.modules.sys.model.c.param.staff.ConvertIdCardParam;
import cn.smarthse.rho.modules.sys.model.c.param.staff.relocation.StaffRelocationExportParam;
import cn.smarthse.rho.modules.sys.model.c.vo.CertStaffChooseListVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffChangeLogVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffSelectInfo;
import cn.smarthse.rho.modules.sys.model.c.vo.staff.RiskStaffBaseInfo;
import cn.smarthse.rho.modules.sys.model.c.vo.staff.StaffRelocationExportVo;
import cn.smarthse.rho.modules.sys.model.c.vo.staffErr.StaffMaintenanceErrorInfo;
import cn.smarthse.rho.modules.sys.model.r.param.RiskMangerGenParam;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysAreaVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysFileVo;
import cn.smarthse.rho.modules.sys.model.wanda.sync.param.WandaSyncParam;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.b.IBOrgService;
import cn.smarthse.rho.modules.sys.service.b.IBPostService;
import cn.smarthse.rho.modules.sys.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.sys.service.sys.ISysFileService;
import cn.smarthse.rho.modules.sys.utils.staff.StaffNameStorageUtil;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.Collection;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CStaffBaseInfoServiceImpl
extends ServiceImpl<CStaffBaseInfoMapper, CStaffBaseInfo>
implements ICStaffBaseInfoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CStaffBaseInfoServiceImpl.class);
    @Autowired
    private IBCompanyService companyService;
    @Autowired
    private IBOrgService orgService;
    @Autowired
    private IBPostService postService;
    @Autowired
    private ISysFileService sysFileService;

    @Override
    public StaffSelectInfo getSelectInfoForAdding(StaffSelectInfoParam param) {
        List<SysFileVo> fileList;
        String idCard = param.getIdCard();
        if (StrUtil.hasBlank((CharSequence[])new CharSequence[]{idCard})) {
            throw new ServiceException("\u4fe1\u606f\u4e0d\u5339\u914d");
        }
        CStaffBaseInfo db = this.getOneByIdCard(idCard);
        if (db == null) {
            return null;
        }
        StaffSelectInfo result = new StaffSelectInfo();
        boolean validCard = IdcardUtil.isValidCard((String)idCard);
        result.setId(db.getId());
        result.setName(db.getName());
        result.setPhone(db.getPhone());
        result.setIdcardType(db.getIdcardType());
        result.setIdcard(db.getIdcard());
        result.setSex(validCard ? Integer.valueOf(IdcardUtil.getGenderByIdCard((String)idCard)) : db.getSex());
        result.setAge(validCard ? Integer.valueOf(IdcardUtil.getAgeByIdCard((String)idCard)) : db.getAge());
        result.setBirthday(validCard ? IdcardUtil.getBirthDate((String)idCard).toLocalDateTime().toLocalDate() : db.getBirthday());
        result.setRayStaffTime(db.getRayStaffTime());
        result.setRaType(db.getRaType());
        result.setHeadId(db.getHeadId());
        if (db.getHeadId() != null && CollUtil.isNotEmpty(fileList = this.sysFileService.getFileVoByIds(String.valueOf(db.getHeadId())))) {
            SysFileVo sysFile = fileList.get(0);
            result.setHeadFileName(sysFile.getFileName());
            result.setHeadFileUrl(sysFile.getFullOssUrl());
        }
        return result;
    }

    @Override
    public List<Long> getCidList(Long staffBaseInfoId, Integer postStatus, Integer staffType) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getCidList(staffBaseInfoId, postStatus, staffType);
    }

    @Override
    public List<Long> getCidListForRiskTask(Long staffBaseInfoId, Integer postStatus, Integer staffType) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getCidListForRiskTask(staffBaseInfoId, postStatus, staffType);
    }

    @Override
    public LayuiGridData<StaffChangeLogVo> getStaffChangeLog(StaffChangeLogParam param) {
        if (CollUtil.isEmpty((Collection)param.getDataIds()) || CollUtil.isEmpty((Collection)param.getFieldValues()) || CollUtil.isEmpty((Collection)param.getTableNames())) {
            throw new ServiceException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<StaffChangeLogVo> list = ((CStaffBaseInfoMapper)this.baseMapper).getStaffChangeLog(param);
        for (StaffChangeLogVo vo : list) {
            this.translateChangeLog(vo);
        }
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    private void translateChangeLog(StaffChangeLogVo vo) {
        String beforeValue = vo.getBeforeValue();
        String afterValue = vo.getAfterValue();
        beforeValue = RhoEncryptUtil.decryptOrReturnOriginalValue((String)beforeValue);
        afterValue = RhoEncryptUtil.decryptOrReturnOriginalValue((String)afterValue);
        beforeValue = StrUtil.isBlank((CharSequence)beforeValue) || StrUtil.equals((CharSequence)beforeValue, (CharSequence)"null") ? null : beforeValue;
        afterValue = StrUtil.isBlank((CharSequence)afterValue) || StrUtil.equals((CharSequence)afterValue, (CharSequence)"null") ? null : afterValue;
        String fieldName = vo.getFieldValue();
        String beforeTranslateValue = null;
        String afterTranslateValue = null;
        boolean isNumeric1 = StrUtil.isNumeric((CharSequence)beforeValue);
        boolean isNumeric2 = StrUtil.isNumeric((CharSequence)afterValue);
        if ("cid".equals(fieldName)) {
            BCompany company1 = null;
            BCompany company2 = null;
            if (isNumeric1) {
                company1 = this.companyService.getByIdIncludeDel(beforeValue);
            }
            if (isNumeric2) {
                company2 = this.companyService.getByIdIncludeDel(afterValue);
            }
            beforeTranslateValue = company1 == null ? null : company1.getName();
            afterTranslateValue = company2 == null ? null : company2.getName();
        } else if ("org_id".equals(fieldName)) {
            BOrg org1 = null;
            BOrg org2 = null;
            if (isNumeric1) {
                org1 = this.orgService.getByIdIncludeDel(Long.valueOf(beforeValue));
            }
            if (isNumeric2) {
                org2 = this.orgService.getByIdIncludeDel(Long.valueOf(afterValue));
            }
            beforeTranslateValue = org1 == null ? null : org1.getName();
            afterTranslateValue = org2 == null ? null : org2.getName();
        } else if ("post_status".equals(fieldName)) {
            if (isNumeric1) {
                beforeTranslateValue = PostStatusEnum.getName((Integer)Integer.valueOf(beforeValue));
            }
            if (isNumeric2) {
                afterTranslateValue = PostStatusEnum.getName((Integer)Integer.valueOf(afterValue));
            }
        } else if ("post".equals(fieldName)) {
            BPost post;
            if (isNumeric1) {
                post = (BPost)this.postService.getById(Long.valueOf(beforeValue));
                String string = beforeTranslateValue = post == null ? null : post.getName();
            }
            if (isNumeric2) {
                post = (BPost)this.postService.getById(Long.valueOf(afterValue));
                afterTranslateValue = post == null ? null : post.getName();
            }
        } else if ("sex".equals(fieldName)) {
            beforeTranslateValue = "0".equals(beforeValue) ? "\u5973" : "\u7537";
            afterTranslateValue = "0".equals(beforeValue) ? "\u5973" : "\u7537";
        } else if ("staff_type".equals(fieldName)) {
            if (StrUtil.isNotBlank((CharSequence)beforeValue)) {
                String string = beforeTranslateValue = "0".equals(beforeValue) ? "\u975e\u653e\u5c04\u5de5\u4f5c\u4eba\u5458" : "\u653e\u5c04\u5de5\u4f5c\u4eba\u5458";
            }
            if (StrUtil.isNotBlank((CharSequence)afterValue)) {
                afterTranslateValue = "0".equals(afterValue) ? "\u975e\u653e\u5c04\u5de5\u4f5c\u4eba\u5458" : "\u653e\u5c04\u5de5\u4f5c\u4eba\u5458";
            }
        } else if ("if_ra_manager".equals(fieldName)) {
            beforeTranslateValue = StrUtil.equals((CharSequence)beforeValue, (CharSequence)"0") ? "\u975e\u653e\u5c04\u536b\u751f\u9632\u62a4\u7ba1\u7406\u4eba\u5458" : "\u653e\u5c04\u536b\u751f\u9632\u62a4\u7ba1\u7406\u4eba\u5458";
            afterTranslateValue = StrUtil.equals((CharSequence)afterValue, (CharSequence)"0") ? "\u975e\u653e\u5c04\u536b\u751f\u9632\u62a4\u7ba1\u7406\u4eba\u5458" : "\u653e\u5c04\u536b\u751f\u9632\u62a4\u7ba1\u7406\u4eba\u5458";
        } else {
            beforeTranslateValue = beforeValue;
            afterTranslateValue = afterValue;
        }
        vo.setBeforeTranslateValue(beforeTranslateValue);
        vo.setAfterTranslateValue(afterTranslateValue);
        if (fieldName.equals("name")) {
            vo.setBeforeTranslateValue(DesensitizationUtils.desensitized((CharSequence)beforeTranslateValue, (DesensitizationType)DesensitizationType.NAME));
            vo.setAfterTranslateValue(DesensitizationUtils.desensitized((CharSequence)afterTranslateValue, (DesensitizationType)DesensitizationType.NAME));
            vo.setBeforeValue(vo.getBeforeTranslateValue());
            vo.setAfterValue(vo.getAfterTranslateValue());
        } else if (fieldName.equals("phone")) {
            vo.setBeforeTranslateValue(DesensitizationUtils.desensitized((CharSequence)beforeTranslateValue, (DesensitizationType)DesensitizationType.MOBILE_PHONE));
            vo.setAfterTranslateValue(DesensitizationUtils.desensitized((CharSequence)afterTranslateValue, (DesensitizationType)DesensitizationType.MOBILE_PHONE));
            vo.setBeforeValue(vo.getBeforeTranslateValue());
            vo.setAfterValue(vo.getAfterTranslateValue());
        } else if (fieldName.equals("idcard")) {
            vo.setBeforeTranslateValue(DesensitizationUtils.desensitized((CharSequence)beforeTranslateValue, (DesensitizationType)DesensitizationType.ID_CARD));
            vo.setAfterTranslateValue(DesensitizationUtils.desensitized((CharSequence)afterTranslateValue, (DesensitizationType)DesensitizationType.ID_CARD));
            vo.setBeforeValue(vo.getBeforeTranslateValue());
            vo.setAfterValue(vo.getAfterTranslateValue());
        }
        vo.setContent(null);
    }

    @Override
    public LayuiGridData<CertStaffChooseListVo> getCertStaffChooseList(CertStaffChooseListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<CertStaffChooseListVo> list = ((CStaffBaseInfoMapper)this.baseMapper).getCertStaffChooseList(param);
        for (CertStaffChooseListVo vo : list) {
            vo.setName(DesensitizationUtils.desensitized((CharSequence)vo.getName(), (DesensitizationType)DesensitizationType.NAME));
        }
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    public boolean hasIdCardConflict(Long id, String idCard) {
        if (StrUtil.isEmpty((CharSequence)idCard)) {
            return false;
        }
        CStaffBaseInfo entity = this.getOneByIdCard(idCard);
        return entity != null && !entity.getId().equals(id);
    }

    @Override
    public CStaffBaseInfo getOneByIdCard(String idCard) {
        if (StrUtil.isBlank((CharSequence)idCard)) {
            return null;
        }
        String idCardEn = SpringEncryptUtils.encrypt((String)idCard);
        CStaffBaseInfo oneByIdCardEn = ((CStaffBaseInfoMapper)this.baseMapper).getOneByIdCard(idCardEn);
        CStaffBaseInfo oneByIdCard = ((CStaffBaseInfoMapper)this.baseMapper).getOneByIdCard(idCard);
        if (oneByIdCardEn != null && oneByIdCard != null && !oneByIdCardEn.getId().equals(oneByIdCard.getId())) {
            throw new ServiceException("error:\u4eba\u5458\u6570\u636e\u91cd\u590d,\u5931\u8d25,idCard:" + DesensitizationUtils.desensitized((CharSequence)idCard, (DesensitizationType)DesensitizationType.ID_CARD));
        }
        return oneByIdCardEn != null ? oneByIdCardEn : oneByIdCard;
    }

    @Override
    public CStaffBaseInfo getOneByNamePhoneForEd(String name, String phone) {
        String nameEn = SpringEncryptUtils.encrypt((String)name);
        String phoneEn = SpringEncryptUtils.encrypt((String)phone);
        return ((CStaffBaseInfoMapper)this.baseMapper).getOneByNamePhoneForEd(nameEn, phoneEn);
    }

    @Override
    public CStaffBaseInfo getOneByIdNamePhoneForEd(Long id, String name, String phone) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getOneByIdNamePhoneForEd(id, name, phone);
    }

    @Override
    public List<CStaffInfoSyncVo> getWandaSyncInfoFromCHData(WandaSyncParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getWandaSyncInfoFromCHData(param);
    }

    @Override
    public List<CStaffInfoSyncVo> getWandaSyncInfoFromDoseData(WandaSyncParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getWandaSyncInfoFromDoseData(param);
    }

    @Override
    public List<CStaffInfoSyncVo> getWandaSyncInfoFromTrainingData(WandaSyncParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getWandaSyncInfoFromTrainingData(param);
    }

    @Override
    public List<CStaffInfoSyncVo> getWandaSyncStaffInfoFromCHData(WandaSyncParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getWandaSyncStaffInfoFromCHData(param);
    }

    @Override
    public List<CStaffInfoSyncVo> getWandaSyncStaffInfoFromDoseData(WandaSyncParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getWandaSyncStaffInfoFromDoseData(param);
    }

    @Override
    public List<CStaffInfoSyncVo> getWandaSyncStaffInfoFromTrainingData(WandaSyncParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getWandaSyncStaffInfoFromTrainingData(param);
    }

    @Override
    public CStaffInfoRangeVo getStaffInfoRangeForCompany(CStaffInfoRangeParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getStaffInfoRangeForCompany(param);
    }

    @Override
    public CStaffInfoRangeVo getStaffInfoRangeForAdmin(CStaffInfoRangeParam param) {
        if (param.getLevel() == null || param.getAreaId() == null) {
            throw new ServiceException("\u7f3a\u5931\u533a\u57df\u6570\u636e");
        }
        return ((CStaffBaseInfoMapper)this.baseMapper).getStaffInfoRangeForAdmin(param);
    }

    @Override
    @Transactional
    public void establishStaffCmContactFromHc(WandaSyncParam param) {
        ((CStaffBaseInfoMapper)this.baseMapper).establishStaffCmContactFromHc(param);
    }

    @Override
    @Transactional
    public void establishStaffCmContactFromDose(WandaSyncParam param) {
        ((CStaffBaseInfoMapper)this.baseMapper).establishStaffCmContactFromDose(param);
    }

    @Override
    @Transactional
    public void establishStaffCmContactFromTrainingCert(WandaSyncParam param) {
        ((CStaffBaseInfoMapper)this.baseMapper).establishStaffCmContactFromTrainingCert(param);
    }

    @Override
    @Transactional
    public void insertStaffBaseInfoFromHC(WandaSyncParam wandaSyncParam) {
        ((CStaffBaseInfoMapper)this.baseMapper).insertStaffBaseInfoFromHC(wandaSyncParam);
    }

    @Override
    @Transactional
    public void insertStaffBaseInfoFromDose(WandaSyncParam wandaSyncParam) {
        ((CStaffBaseInfoMapper)this.baseMapper).insertStaffBaseInfoFromDose(wandaSyncParam);
    }

    @Override
    @Transactional
    public void insertStaffBaseInfoFromTraining(WandaSyncParam wandaSyncParam) {
        ((CStaffBaseInfoMapper)this.baseMapper).insertStaffBaseInfoFromTraining(wandaSyncParam);
    }

    @Override
    @Transactional
    public void dealViceDataRelation(WandaSyncParam param) {
        ((CStaffBaseInfoMapper)this.baseMapper).dealViceDataRelation(param);
    }

    @Override
    public List<RiskStaffBaseInfo> getListForGenHcRisk(RiskMangerGenParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getListForGenRisk(param);
    }

    @Override
    public List<RiskStaffBaseInfo> getListForGenHcPreRiskV4(RiskMangerGenParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getListForGenHcPreRiskV4(param);
    }

    @Override
    public List<RiskStaffBaseInfo> getListForGenHcOnRiskV4(RiskMangerGenParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getListForGenHcOnRiskV4(param);
    }

    @Override
    public List<RiskStaffBaseInfo> getListForGenHcDtRiskV4(RiskMangerGenParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getListForGenHcDtRiskV4(param);
    }

    @Override
    public List<RiskStaffBaseInfo> getListForGenHcErrorRiskV4(RiskMangerGenParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getListForGenHcErrorRiskV4(param);
    }

    @Override
    public List<RiskStaffBaseInfo> getListForGenTrainingRisk(RiskMangerGenParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getListForGenTrainingRisk(param);
    }

    @Override
    public List<CStaffBaseInfo> getListForGenDoseRisk(RiskMangerGenParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getListForGenDoseRisk(param);
    }

    @Override
    public Integer checkName(CheckNameParam param) {
        param.setName(StrUtil.trim((CharSequence)param.getName()));
        if (StrUtil.isBlank((CharSequence)param.getName())) {
            throw new ServiceException("\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (param.cid == null) {
            throw new ServiceException("\u53c2\u6570\u9519\u8bef");
        }
        Integer num = ((CStaffBaseInfoMapper)this.baseMapper).countStaffNumByName(param);
        return num == null || num == 0 ? 0 : 1;
    }

    @Override
    public List<SysAreaVo> getAreaList(Long baseInfoId) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getAreaList(baseInfoId);
    }

    @Override
    @Transactional
    public void convertIdCard(ConvertIdCardParam param) {
        List<CStaffBaseInfo> dbList = ((CStaffBaseInfoMapper)this.baseMapper).getNeedConvertList();
        for (CStaffBaseInfo db : dbList) {
            if (!StrUtil.contains((CharSequence)db.getIdcard(), (CharSequence)"x")) continue;
            try {
                db.setIdcard(StrUtil.toUpperCase((CharSequence)db.getIdcard()));
                this.updateById(db);
            }
            catch (Exception e) {
                log.error("\u3010\u8eab\u4efd\u8bc1\u5927\u5c0f\u5199\u8f6c\u6362\u3011\u3010\u4eba\u5458\u57fa\u7840\u4fe1\u606f\u3011\u5f02\u5e38,sbId:{},e:{}", (Object)db.getId(), (Object)e);
            }
        }
    }

    @Override
    @Transactional
    public void convertName(ConvertIdCardParam param) {
        List<CStaffBaseInfo> dbList = ((CStaffBaseInfoMapper)this.baseMapper).getNeedConvertListForName(param);
        for (CStaffBaseInfo db : dbList) {
            if (StrUtil.isBlank((CharSequence)db.getName())) continue;
            try {
                db.setName(StaffNameStorageUtil.dealName((String)db.getName()));
                this.updateById(db);
            }
            catch (Exception e) {
                log.error("\u3010\u540d\u5b57\u8f6c\u6362\u3011\u3010\u4eba\u5458\u57fa\u7840\u4fe1\u606f\u3011\u5f02\u5e38,sbId:{},name:{},e:{}", new Object[]{db.getId(), DesensitizationUtils.desensitized((CharSequence)db.getName(), (DesensitizationType)DesensitizationType.NAME), e});
            }
        }
    }

    @Override
    public List<StaffMaintenanceErrorInfo> getListFtMtStaffErrorInfo(BStaffErrorMaintenanceParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getListFtMtStaffErrorInfo(param);
    }

    @Override
    public StaffMaintenanceErrorInfo getOneFtMtStaffErrorInfo(Long sbId) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getOneFtMtStaffErrorInfo(sbId);
    }

    @Override
    public Integer getCompanyViewNumBySbId(ViewNumParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getCompanyViewNumBySbId(param);
    }

    @Override
    public List<Long> getCidListForMtCompanyErrorInfo(List<Long> sbIdList) {
        if (CollUtil.isEmpty(sbIdList)) {
            return null;
        }
        return ((CStaffBaseInfoMapper)this.baseMapper).getCidListForMtCompanyErrorInfo(sbIdList);
    }

    @Override
    public RiskStaffBaseInfo getInfoUnDeFieldForRisk(Long sbId) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getInfoUnDeFieldForRisk(sbId);
    }

    @Override
    public List<StaffRelocationExportVo> getListForRelationExport(StaffRelocationExportParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getListForRelationExport(param);
    }
}

