/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.sys.service.c.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.core.framework.model.LayuiGridParam;
import cn.smarthse.rho.modules.sys.dao.c.CHealthCheckDataMapper;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.c.CHealthCheckData;
import cn.smarthse.rho.modules.sys.entity.c.CStaffBaseInfo;
import cn.smarthse.rho.modules.sys.enums.RhoRiskCycleEnum;
import cn.smarthse.rho.modules.sys.enums.health.HealthBodyCheckTypeEnum;
import cn.smarthse.rho.modules.sys.enums.health.HealthCheckResultEnum;
import cn.smarthse.rho.modules.sys.model.c.param.CHealthCheckQueryParam;
import cn.smarthse.rho.modules.sys.model.c.param.staff.CheckStaffRelationParam;
import cn.smarthse.rho.modules.sys.model.c.param.staff.ConvertIdCardParam;
import cn.smarthse.rho.modules.sys.model.c.param.staff.relocation.StaffRelocateParam;
import cn.smarthse.rho.modules.sys.model.home.vo.HomeData33;
import cn.smarthse.rho.modules.sys.model.r.vo.CalculateVo;
import cn.smarthse.rho.modules.sys.model.r.vo.HcFactorVo;
import cn.smarthse.rho.modules.sys.model.wanda.sync.param.WandaSyncParam;
import cn.smarthse.rho.modules.sys.provider.c.ICHealthCheckDataProvider;
import cn.smarthse.rho.modules.sys.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.service.c.ICHealthCheckDataService;
import cn.smarthse.rho.modules.sys.utils.risk.WarningTypeUtil;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CHealthCheckDataServiceImpl
extends ServiceImpl<CHealthCheckDataMapper, CHealthCheckData>
implements ICHealthCheckDataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CHealthCheckDataServiceImpl.class);
    @Autowired
    @Lazy
    private IBCompanyService companyService;
    @DubboReference
    private ICHealthCheckDataProvider healthCheckDataProvider;

    @Override
    public CHealthCheckData getLastHealthCheckData(Long staffBaseInfoId) {
        return ((CHealthCheckDataMapper)this.baseMapper).getLastHealthCheckData(staffBaseInfoId);
    }

    @Override
    public CHealthCheckData getLastValidData(Long staffBaseInfoId) {
        return ((CHealthCheckDataMapper)this.baseMapper).getLastValidData(staffBaseInfoId);
    }

    @Override
    @Transactional
    public void dealHealthCheckStaffRelation(WandaSyncParam param) {
        ((CHealthCheckDataMapper)this.baseMapper).dealHealthCheckStaffRelation(param);
    }

    @Override
    public CalculateVo calculate(CHealthCheckData lastData) {
        if (lastData.getCheckDate() == null) {
            return null;
        }
        LocalDateTime expireDate = this.calculateExpireDate(lastData);
        LocalDateTime startDate = LocalDateTimeUtil.of((TemporalAccessor)lastData.getCheckDate());
        Integer warnType = this.calculateWarnType(lastData);
        CalculateVo calculate = new CalculateVo();
        calculate.setWarningType(warnType);
        calculate.setExpireTime(expireDate);
        calculate.setStartTime(startDate);
        return calculate;
    }

    @Override
    public CalculateVo calculate2(CStaffBaseInfo entity) {
        if (entity == null) {
            return null;
        }
        if (entity.getCreateDate() == null) {
            return null;
        }
        CalculateVo calculate = new CalculateVo();
        calculate.setWarningType(WarningTypeUtil.calculateNonDataWarningType((LocalDateTime)entity.getCreateDate()));
        calculate.setExpireTime(null);
        calculate.setStartTime(entity.getCreateDate());
        return calculate;
    }

    @Override
    public CHealthCheckData getLastPreHealthCheckDataForRiskPreJob(Long staffBaseInfoId, LocalDateTime start, LocalDateTime end) {
        return ((CHealthCheckDataMapper)this.baseMapper).getLastPreHealthCheckDataForRiskPreJob(staffBaseInfoId, start, end, HealthBodyCheckTypeEnum.PRE_POST.getValue());
    }

    @Override
    public CHealthCheckData getLastDtHealthCheckDataForRiskPreJob(Long staffBaseInfoId, LocalDateTime start, LocalDateTime end) {
        return ((CHealthCheckDataMapper)this.baseMapper).getLastDtHealthCheckDataForRiskPreJob(staffBaseInfoId, start, end, HealthBodyCheckTypeEnum.DT_ING_POST.getValue(), HealthBodyCheckTypeEnum.DT_POST.getValue());
    }

    @Override
    public CHealthCheckData getLastHealthCheckDataForGenRiskPreJobV4(Long staffBaseInfoId, LocalDateTime start) {
        return ((CHealthCheckDataMapper)this.baseMapper).getLastHealthCheckDataForGenRiskPreJobV4(staffBaseInfoId, start);
    }

    @Override
    public CHealthCheckData getLastHealthCheckDataForGenRiskOnJobV4(Long staffBaseInfoId, LocalDateTime start) {
        return ((CHealthCheckDataMapper)this.baseMapper).getLastHealthCheckDataForGenRiskOnJobV4(staffBaseInfoId, start);
    }

    @Override
    public CHealthCheckData getLastHealthCheckDataForGenRiskErrorV4(Long staffBaseInfoId, LocalDateTime start) {
        return ((CHealthCheckDataMapper)this.baseMapper).getLastHealthCheckDataForGenRiskErrorV4(staffBaseInfoId, start);
    }

    @Override
    public CHealthCheckData getLastDtHealthCheckDataForRiskDtJob(Long staffBaseInfoId, LocalDateTime start, LocalDateTime end) {
        return ((CHealthCheckDataMapper)this.baseMapper).getLastDtHealthCheckDataForRiskDtJob(staffBaseInfoId, start, end, HealthBodyCheckTypeEnum.DT_ING_POST.getValue(), HealthBodyCheckTypeEnum.DT_POST.getValue());
    }

    @Override
    public CHealthCheckData getLastDtHealthCheckDataForRiskDtJobV4(Long staffBaseInfoId, LocalDateTime start, LocalDateTime end) {
        return ((CHealthCheckDataMapper)this.baseMapper).getLastDtHealthCheckDataForRiskDtJobV4(staffBaseInfoId, start, end);
    }

    @Override
    public CHealthCheckData getLastOnHealthCheckDataForRiskOnJob(Long staffBaseInfoId, LocalDateTime startTime) {
        return ((CHealthCheckDataMapper)this.baseMapper).getLastOnHealthCheckDataForRiskOnJob(staffBaseInfoId, startTime, HealthBodyCheckTypeEnum.ON_POST.getValue());
    }

    @Override
    public CHealthCheckData getLastDataForFcRisk(Long id, LocalDate startDate, LocalDate endDate) {
        return ((CHealthCheckDataMapper)this.baseMapper).getLastDataForFcRisk(id, startDate, endDate);
    }

    @Override
    @Transactional
    public void convertIdCard(ConvertIdCardParam param) {
        List<CHealthCheckData> dbList = ((CHealthCheckDataMapper)this.baseMapper).getNeedConvertList();
        for (CHealthCheckData db : dbList) {
            if (!StrUtil.contains((CharSequence)db.getIdcard(), (CharSequence)"x")) continue;
            try {
                db.setIdcard(StrUtil.toUpperCase((CharSequence)db.getIdcard()));
                this.updateById(db);
            }
            catch (Exception e) {
                log.error("\u3010\u8eab\u4efd\u8bc1\u5927\u5c0f\u5199\u8f6c\u6362\u3011\u3010\u4f53\u68c0\u3011\u5f02\u5e38,hcId:{},e:{}", (Object)db.getId(), (Object)e);
            }
        }
    }

    private Integer calculateWarnType(CHealthCheckData lastData) {
        if (lastData.getCheckDate() == null) {
            return null;
        }
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime expireDate = this.calculateExpireDate(lastData);
        return WarningTypeUtil.calculateHasDataWarningType((LocalDateTime)now, (LocalDateTime)expireDate);
    }

    private LocalDateTime calculateExpireDate(CHealthCheckData lastData) {
        if (lastData.getCheckDate() == null) {
            return null;
        }
        return LocalDateTimeUtil.offset((LocalDateTime)LocalDateTimeUtil.of((TemporalAccessor)lastData.getCheckDate()), (long)RhoRiskCycleEnum.HC.getCycle(), (TemporalUnit)RhoRiskCycleEnum.HC.getUnit());
    }

    @Override
    public LayuiGridData<CHealthCheckData> getResultList(CHealthCheckQueryParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<CHealthCheckData> dataResultList = this.getDataResultList(param);
        if (CollUtil.isNotEmpty(dataResultList)) {
            List hcIdList = dataResultList.stream().map(CHealthCheckData::getId).collect(Collectors.toList());
            Map viewHcFactorMap = this.healthCheckDataProvider.getViewHcFactorMap(hcIdList);
            for (CHealthCheckData result : dataResultList) {
                if (!viewHcFactorMap.containsKey(result.getId())) continue;
                HcFactorVo hcFactorVo = (HcFactorVo)viewHcFactorMap.get(result.getId());
                result.setRiskFactorName(hcFactorVo.getName());
                result.setRiskFactorCode(hcFactorVo.getCode());
            }
        }
        return new LayuiGridData((Page)dataResultList, (LayuiGridParam)param);
    }

    @Override
    public LayuiGridData<CHealthCheckData> getListForArchive(CHealthCheckQueryParam param) {
        List hcIdList;
        Map viewHcFactorMap;
        BCompany company = (BCompany)this.companyService.getById(param.getCid());
        param.setCreditCode(company.getCreditCode());
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<CHealthCheckData> resultList = ((CHealthCheckDataMapper)this.baseMapper).getListForArchive(param);
        for (CHealthCheckData data : resultList) {
            data.setResult(HealthCheckResultEnum.getName((String)data.getResultCode()));
        }
        if (CollUtil.isNotEmpty(resultList) && (viewHcFactorMap = this.healthCheckDataProvider.getViewHcFactorMap(hcIdList = resultList.stream().map(v -> v.getId()).collect(Collectors.toList()))) != null) {
            for (CHealthCheckData result : resultList) {
                if (!viewHcFactorMap.containsKey(result.getId())) continue;
                HcFactorVo hcFactorVo = (HcFactorVo)viewHcFactorMap.get(result.getId());
                result.setRiskFactorName(hcFactorVo.getName());
                result.setRiskFactorCode(hcFactorVo.getCode());
            }
        }
        return new LayuiGridData((Page)resultList, (LayuiGridParam)param);
    }

    List<CHealthCheckData> getDataResultList(CHealthCheckQueryParam param) {
        return ((CHealthCheckDataMapper)this.baseMapper).getDataResultList(param);
    }

    @Override
    public HomeData33 getHomeData33(Long cid) {
        return ((CHealthCheckDataMapper)this.baseMapper).getHomeData33(cid);
    }

    @Override
    public CHealthCheckData getLastData(Long staffBaseInfoId) {
        return ((CHealthCheckDataMapper)this.baseMapper).getLastCheckHealData(staffBaseInfoId);
    }

    @Override
    public List<HcFactorVo> getViewHcFactorList(List<Long> hcIdList) {
        List<HcFactorVo> tempList = ((CHealthCheckDataMapper)this.baseMapper).getViewHcFactorList(hcIdList);
        ArrayList<HcFactorVo> resultList = new ArrayList<HcFactorVo>();
        for (HcFactorVo vo : tempList) {
            String code = vo.getCode1();
            code = StrUtil.isBlank((CharSequence)code) ? vo.getCode2() : code;
            if (!StrUtil.isNotBlank((CharSequence)(code = StrUtil.isBlank((CharSequence)code) ? vo.getCode3() : code))) continue;
            List<String> codeList = StrUtil.split((CharSequence)code, (CharSequence)",").stream().distinct().collect(Collectors.toList());
            List<String> nameList = ((CHealthCheckDataMapper)this.baseMapper).getFactoryName(codeList);
            vo.setNameList(nameList);
            vo.setName(CollUtil.join(nameList, (CharSequence)","));
            resultList.add(vo);
        }
        return resultList;
    }

    @Override
    public Map<Long, HcFactorVo> getViewHcFactorMap(List<Long> hcIdList) {
        List<HcFactorVo> viewHcFactorList = this.getViewHcFactorList(hcIdList);
        HashMap<Long, HcFactorVo> map = new HashMap<Long, HcFactorVo>();
        for (HcFactorVo vo : viewHcFactorList) {
            map.put(vo.getHcId(), vo);
        }
        return map;
    }

    @Override
    public CHealthCheckData getLastDataForDeleting(CheckStaffRelationParam param) {
        return ((CHealthCheckDataMapper)this.baseMapper).getLastDataForDeleting(param);
    }

    @Override
    public CHealthCheckData getInfoExEnForRisk(Long hcId) {
        return ((CHealthCheckDataMapper)this.baseMapper).getInfoExEnForRisk(hcId);
    }

    @Override
    public List<CHealthCheckData> getListForRelocating(StaffRelocateParam param) {
        return ((CHealthCheckDataMapper)this.baseMapper).getListForRelocating(param);
    }
}

